/*
 * Decompiled with CFR 0.152.
 */
package elocindev.necronomicon.mixin.common.item;

import elocindev.necronomicon.api.text.IAnimatedGradientName;
import elocindev.necronomicon.api.text.IGradientName;
import elocindev.necronomicon.api.text.TextAPI;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class AnimatedItemNameMixin {
    @Inject(method={"getHoverName()Lnet/minecraft/network/chat/Component;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getName(CallbackInfoReturnable<Component> cir) {
        ItemStack stack = (ItemStack)this;
        Component name = (Component)stack.get(DataComponents.ITEM_NAME);
        Component customName = (Component)stack.get(DataComponents.CUSTOM_NAME);
        Item item = stack.getItem();
        if (item instanceof IGradientName) {
            IGradientName gradient = (IGradientName)item;
            if (customName == null) {
                try {
                    colors = gradient.getGradientColors();
                    MutableComponent itemName = TextAPI.Styles.getStaticGradient(name, colors[0], colors[1]);
                    cir.setReturnValue((Object)itemName);
                    return;
                }
                catch (Exception e) {
                    stack.remove(DataComponents.CUSTOM_NAME);
                }
            } else if (gradient.applyOnCustomName()) {
                try {
                    colors = gradient.getGradientColors();
                    MutableComponent itemName = TextAPI.Styles.getStaticGradient(customName, colors[0], colors[1]);
                    cir.setReturnValue((Object)itemName);
                    return;
                }
                catch (Exception e) {
                    stack.remove(DataComponents.CUSTOM_NAME);
                }
            }
        } else {
            Item e = stack.getItem();
            if (e instanceof IAnimatedGradientName) {
                IAnimatedGradientName animatedGradient = (IAnimatedGradientName)e;
                if (customName == null) {
                    try {
                        colors = animatedGradient.getGradientColors();
                        MutableComponent itemName = TextAPI.Styles.getGradient(name, 1, colors[0], colors[1], animatedGradient.getAnimatedNameSpeed());
                        if (animatedGradient.isRainbowName()) {
                            itemName = TextAPI.Styles.getRainbowGradient(name, 1, animatedGradient.getAnimatedNameSpeed());
                        }
                        cir.setReturnValue((Object)itemName);
                        return;
                    }
                    catch (Exception e2) {
                        stack.remove(DataComponents.CUSTOM_NAME);
                    }
                } else if (animatedGradient.applyOnCustomName()) {
                    try {
                        colors = animatedGradient.getGradientColors();
                        MutableComponent itemName = TextAPI.Styles.getGradient(customName, 1, colors[0], colors[1], animatedGradient.getAnimatedNameSpeed());
                        if (animatedGradient.isRainbowName()) {
                            itemName = TextAPI.Styles.getRainbowGradient(customName, 1, animatedGradient.getAnimatedNameSpeed());
                        }
                        cir.setReturnValue((Object)itemName);
                        return;
                    }
                    catch (Exception e3) {
                        stack.remove(DataComponents.CUSTOM_NAME);
                    }
                }
            }
        }
    }
}

