/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.block;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;

public class Plants {

    public static class Podzol
    implements IBlockPlacementHandler {
        @Override
        public void place(LevelAccessor world, BlockState state, BlockPos pos, RandomSource rand, Theme theme, SecondaryTheme secondaryTheme, int lootLevel) {
            world.setBlock(pos, state, 2);
            BlockState flower = DungeonBlocks.TALL_FLOWERS.roll(rand).defaultBlockState();
            BlockPos lowerPart = pos.above();
            BlockPos upperPart = lowerPart.above();
            world.setBlock(lowerPart, DungeonBlocks.applyProperty(flower, BlockStateProperties.DOUBLE_BLOCK_HALF, DoubleBlockHalf.LOWER), 2);
            world.setBlock(upperPart, DungeonBlocks.applyProperty(flower, BlockStateProperties.DOUBLE_BLOCK_HALF, DoubleBlockHalf.UPPER), 2);
        }
    }

    public static class FlowerPot
    implements IBlockPlacementHandler {
        @Override
        public void place(LevelAccessor world, BlockState state, BlockPos pos, RandomSource rand, Theme theme, SecondaryTheme secondaryTheme, int lootLevel) {
            world.setBlock(pos, DungeonBlocks.POTTED_FLOWERS.roll(rand).defaultBlockState(), 2);
        }
    }

    public static class Farmland
    implements IBlockPlacementHandler {
        @Override
        public void place(LevelAccessor world, BlockState state, BlockPos pos, RandomSource rand, Theme theme, SecondaryTheme secondaryTheme, int lootLevel) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.MOISTURE, (Comparable)Integer.valueOf(7));
            world.setBlock(pos, state, 2);
            BlockPos cropPos = new BlockPos(pos.getX(), pos.getY() + 1, pos.getZ());
            if ((double)rand.nextFloat() < 0.6) {
                BlockState crop = DungeonBlocks.CROPS.roll(rand).defaultBlockState();
                if (crop.hasProperty((Property)BlockStateProperties.AGE_7)) {
                    crop = (BlockState)crop.setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(4 + rand.nextInt(4)));
                }
                world.setBlock(cropPos, crop, 2);
            } else {
                world.setBlock(cropPos, Blocks.CAVE_AIR.defaultBlockState(), 2);
            }
        }
    }
}

