/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.decoration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.decoration.DungeonDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public record ScatteredDecoration(BlockStateProvider blockStateProvider, float chance) implements DungeonDecoration
{
    @Override
    public void decorate(DungeonModel model, LevelAccessor world, BlockPos pos, RandomSource random, BoundingBox worldGenBounds, BoundingBox structureBounds, DungeonPiece piece) {
        boolean ew = piece.rotation == Rotation.NONE || piece.rotation == Rotation.CLOCKWISE_180;
        int maxX = ew ? model.width : model.length;
        int maxZ = ew ? model.length : model.width;
        for (int x = 1; x < maxX - 1; ++x) {
            for (int y = 0; y < model.height; ++y) {
                for (int z = 1; z < maxZ - 1; ++z) {
                    boolean _up;
                    BlockPos currentPos = new BlockPos(pos.getX() + x, pos.getY() + y, pos.getZ() + z);
                    if (!worldGenBounds.isInside((Vec3i)currentPos) || !structureBounds.isInside((Vec3i)currentPos) || DungeonBuilder.isBlockProtected(world, currentPos) || !world.isEmptyBlock(currentPos) || !(random.nextFloat() < this.chance)) continue;
                    BlockPos north = currentPos.north();
                    BlockPos east = currentPos.east();
                    BlockPos south = currentPos.south();
                    BlockPos west = currentPos.west();
                    BlockPos up = currentPos.above();
                    boolean _north = worldGenBounds.isInside((Vec3i)north) && structureBounds.isInside((Vec3i)north) && world.getBlockState(north).canOcclude();
                    boolean _east = worldGenBounds.isInside((Vec3i)east) && structureBounds.isInside((Vec3i)east) && world.getBlockState(east).canOcclude();
                    boolean _south = worldGenBounds.isInside((Vec3i)south) && structureBounds.isInside((Vec3i)south) && world.getBlockState(south).canOcclude();
                    boolean _west = worldGenBounds.isInside((Vec3i)west) && structureBounds.isInside((Vec3i)west) && world.getBlockState(west).canOcclude();
                    boolean bl = _up = worldGenBounds.isInside((Vec3i)up) && structureBounds.isInside((Vec3i)up) && world.getBlockState(up).canOcclude();
                    if (!_north && !_east && !_south && !_west && !_up) continue;
                    world.setBlock(currentPos, this.blockStateProvider.get(world, currentPos, random), 2);
                }
            }
        }
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "scattered");
        object.addProperty("chance", (Number)Float.valueOf(this.chance));
        object.add("block", (JsonElement)this.blockStateProvider.serialize());
        return object;
    }
}

