/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece.room;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.init.ModStructurePieceTypes;

public class DungeonSpiderRoom
extends DungeonPiece {
    private BlockPos[] spawners;
    private BlockPos[] chests;

    public DungeonSpiderRoom(CompoundTag nbt) {
        super((StructurePieceType)ModStructurePieceTypes.SPIDER_ROOM.get(), nbt);
        CompoundTag pos;
        int i;
        ListTag list;
        if (nbt.contains("spawners")) {
            list = nbt.getList("spawners", 10);
            this.spawners = new BlockPos[list.size()];
            for (i = 0; i < this.spawners.length; ++i) {
                pos = list.getCompound(i);
                this.spawners[i] = new BlockPos(pos.getInt("x"), pos.getInt("y"), pos.getInt("z"));
            }
        }
        if (nbt.contains("chests")) {
            list = nbt.getList("chests", 10);
            this.chests = new BlockPos[list.size()];
            for (i = 0; i < this.chests.length; ++i) {
                pos = list.getCompound(i);
                this.chests[i] = new BlockPos(pos.getInt("x"), pos.getInt("y"), pos.getInt("z"));
            }
        }
    }

    @Override
    public void setup(RandomSource rand) {
        int floor = this.y + 1;
        int chests = 1 + rand.nextInt(2);
        int spawners = chests + rand.nextInt(2);
        this.chests = new BlockPos[chests];
        this.spawners = new BlockPos[spawners];
        int x = 0;
        int z = 0;
        for (int i = 0; i < spawners; ++i) {
            x = (x + 1 + rand.nextInt(3)) % 9;
            z = (z + 1 + rand.nextInt(3)) % 9;
            this.spawners[i] = new BlockPos(this.x + x, floor + rand.nextInt(2), this.z + z);
            if (i >= chests) continue;
            this.chests[i] = new BlockPos(this.spawners[i].getX(), this.spawners[i].getY() == floor ? floor + 1 : floor, this.spawners[i].getZ());
        }
    }

    public void postProcess(WorldGenLevel p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, RandomSource p_230383_4_, BoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
    }

    @Override
    public int getDungeonPieceType() {
        return 15;
    }

    @Override
    public void setupModel(DungeonBuilder builder, ModelSelector modelSelector, List<DungeonPiece> pieces, RandomSource rand) {
    }

    @Override
    public void createBoundingBox() {
        this.boundingBox = new BoundingBox(this.x, this.y, this.z, this.x + 8, this.y + 8, this.z + 8);
    }

    @Override
    public void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
        super.addAdditionalSaveData(context, tagCompound);
        if (this.spawners != null) {
            tagCompound.put("spawners", (Tag)DungeonSpiderRoom.positionsToNbt(this.spawners));
        }
        if (this.chests != null) {
            tagCompound.put("chests", (Tag)DungeonSpiderRoom.positionsToNbt(this.chests));
        }
    }
}

