/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class FishLargeModel<T extends Entity>
extends ListModel<T> {
    private final ModelPart head;
    private final ModelPart topFin;
    private final ModelPart tail;
    private final ModelPart leftFin;
    private final ModelPart body;
    private final ModelPart rightFin;
    private final ModelPart headFront;
    private final ModelPart bottomFin;

    public FishLargeModel(ModelPart part) {
        this.head = part.getChild("head");
        this.topFin = part.getChild("top_fin");
        this.tail = part.getChild("tail");
        this.leftFin = part.getChild("left_fin");
        this.body = part.getChild("body");
        this.rightFin = part.getChild("right_fin");
        this.headFront = part.getChild("head_front");
        this.bottomFin = part.getChild("bottom_fin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition modelDefinition = new MeshDefinition();
        PartDefinition def = modelDefinition.getRoot();
        def.addOrReplaceChild("head", CubeListBuilder.create().texOffs(11, 0).addBox(-1.0f, -2.0f, -3.0f, 2.0f, 4.0f, 3.0f), PartPose.offset((float)0.0f, (float)22.0f, (float)0.0f));
        def.addOrReplaceChild("top_fin", CubeListBuilder.create().texOffs(18, -7).addBox(0.0f, -1.0f, -1.0f, 0.0f, 2.0f, 7.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        def.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(21, 2).addBox(0.0f, -2.0f, 0.0f, 0.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)21.5f, (float)7.0f));
        def.addOrReplaceChild("left_fin", CubeListBuilder.create().texOffs(22, 4).addBox(0.0f, 0.0f, -1.0f, 2.0f, 0.0f, 2.0f), PartPose.offsetAndRotation((float)1.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        def.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 1).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 5.0f, 7.0f), PartPose.offset((float)0.0f, (float)22.0f, (float)0.0f));
        def.addOrReplaceChild("right_fin", CubeListBuilder.create().texOffs(26, 4).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 0.0f, 2.0f), PartPose.offsetAndRotation((float)-1.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f));
        def.addOrReplaceChild("head_front", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 3.0f, 1.0f), PartPose.offset((float)0.0f, (float)22.0f, (float)-3.0f));
        def.addOrReplaceChild("bottom_fin", CubeListBuilder.create().texOffs(20, 6).addBox(0.0f, -1.0f, 0.0f, 0.0f, 2.0f, 6.0f), PartPose.offset((float)0.0f, (float)26.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelDefinition, (int)32, (int)32);
    }

    @Nonnull
    public Iterable<ModelPart> parts() {
        return ImmutableList.of((Object)this.head, (Object)this.topFin, (Object)this.tail, (Object)this.leftFin, (Object)this.body, (Object)this.rightFin, (Object)this.headFront, (Object)this.bottomFin);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float movement = 1.0f;
        if (!entity.isInWater()) {
            movement = 1.5f;
        }
        this.tail.yRot = -movement * 0.45f * Mth.sin((float)(0.6f * ageInTicks));
    }
}

