/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.entity;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.init.AquaEntities;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class TurtleLandEntity
extends Animal {
    private static final EntityDimensions BABY_DIMENSIONS = ((EntityType)AquaEntities.BOX_TURTLE.get()).getDimensions().scale(0.5f).withEyeHeight(0.175f);

    public TurtleLandEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new TurtleLandMovementController(this);
        this.setPathfindingMalus(PathType.WATER, 0.2f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new TurtleLandSwimGoal());
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.05));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.15, (Predicate)this.getTurtleEdible(), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new GetOutOfWaterGoal(this));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.1).add(Attributes.ARMOR, 1.5);
    }

    public boolean isFood(@Nonnull ItemStack stack) {
        return this.getTurtleEdible().test(stack);
    }

    public Ingredient getTurtleEdible() {
        return Ingredient.of(AquacultureAPI.Tags.TURTLE_EDIBLE);
    }

    @Nullable
    public AgeableMob getBreedOffspring(@Nonnull ServerLevel world, @Nonnull AgeableMob ageableMob) {
        return (AgeableMob)this.getType().create(this.level());
    }

    public boolean canDrownInFluidType(FluidType type) {
        return type == NeoForgeMod.WATER_TYPE.value() ? false : super.canDrownInFluidType(type);
    }

    protected float getWaterSlowDown() {
        return 1.0f;
    }

    static class TurtleLandMovementController
    extends MoveControl {
        private final TurtleLandEntity turtle;

        TurtleLandMovementController(TurtleLandEntity turtle) {
            super((Mob)turtle);
            this.turtle = turtle;
        }

        public void tick() {
            super.tick();
            this.updateSpeed();
        }

        private void updateSpeed() {
            if (this.turtle.isInWater()) {
                if (this.turtle.isBaby()) {
                    this.turtle.setSpeed(0.2f);
                } else {
                    this.turtle.setSpeed(0.18f);
                }
            } else if (this.turtle.onGround()) {
                this.turtle.setSpeed(0.1f);
            }
        }
    }

    public class TurtleLandSwimGoal
    extends FloatGoal {
        public TurtleLandSwimGoal() {
            super((Mob)TurtleLandEntity.this);
        }

        public boolean canUse() {
            return TurtleLandEntity.this.isInWater() && TurtleLandEntity.this.getFluidHeight(FluidTags.WATER) > 0.1375 || TurtleLandEntity.this.isInLava();
        }
    }

    static class GetOutOfWaterGoal
    extends MoveToBlockGoal {
        private final TurtleLandEntity turtle;

        private GetOutOfWaterGoal(TurtleLandEntity turtle) {
            super((PathfinderMob)turtle, turtle.isBaby() ? 1.4 : 1.2, 24);
            this.turtle = turtle;
            this.verticalSearchStart = -1;
        }

        public void tick() {
            super.tick();
        }

        public boolean canContinueToUse() {
            return this.turtle.isInWater() && this.tryTicks <= 1200 && this.isValidTarget((LevelReader)this.turtle.level(), this.blockPos);
        }

        public boolean canUse() {
            return this.turtle.isInWater() && super.canUse();
        }

        protected boolean isValidTarget(LevelReader reader, @Nonnull BlockPos pos) {
            Block block = reader.getBlockState(pos).getBlock();
            return !(block instanceof LiquidBlock);
        }
    }
}

