/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.types.Type;
import com.teammetallurgy.aquaculture.block.blockentity.NeptunesBountyBlockEntity;
import com.teammetallurgy.aquaculture.block.blockentity.TackleBoxBlockEntity;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AquaBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_DEFERRED = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"aquaculture");
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<NeptunesBountyBlockEntity>> NEPTUNES_BOUNTY = AquaBlockEntities.register("neptunes_bounty", () -> BlockEntityType.Builder.of(NeptunesBountyBlockEntity::new, (Block[])new Block[]{(Block)AquaBlocks.NEPTUNES_BOUNTY.get()}));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TackleBoxBlockEntity>> TACKLE_BOX = AquaBlockEntities.register("tackle_box", () -> BlockEntityType.Builder.of(TackleBoxBlockEntity::new, (Block[])new Block[]{(Block)AquaBlocks.TACKLE_BOX.get()}));

    public static <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> register(@Nonnull String name, @Nonnull Supplier<BlockEntityType.Builder<T>> initializer) {
        Type type = Util.fetchChoiceType((DSL.TypeReference)References.BLOCK_ENTITY, (String)("aquaculture:" + name));
        return BLOCK_ENTITY_DEFERRED.register(name, () -> ((BlockEntityType.Builder)initializer.get()).build(type));
    }
}

