/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.crafting;

import java.util.function.Consumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.StatefulComponentItemHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingUpgradeItem;

public class CraftingUpgradeWrapper
extends UpgradeWrapperBase<CraftingUpgradeWrapper, CraftingUpgradeItem> {
    private final StatefulComponentItemHandler inventory;

    public CraftingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.inventory = new StatefulComponentItemHandler((MutableDataComponentHolder)upgrade, DataComponents.CONTAINER, 9){

            @Override
            protected void onContentsChanged(int slot, ItemStack oldStack, ItemStack newStack) {
                super.onContentsChanged(slot, oldStack, newStack);
                CraftingUpgradeWrapper.this.save();
            }

            @Override
            public boolean isItemValid(int slot, ItemStack stack) {
                return true;
            }
        };
    }

    public StatefulComponentItemHandler getInventory() {
        return this.inventory;
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    public boolean shouldShiftClickIntoStorage() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.SHIFT_CLICK_INTO_STORAGE, (Object)true);
    }

    public void setShiftClickIntoStorage(boolean shiftClickIntoStorage) {
        this.upgrade.set(ModCoreDataComponents.SHIFT_CLICK_INTO_STORAGE, (Object)shiftClickIntoStorage);
        this.save();
    }
}

