/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io.nbt;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import journeymap.common.Journeymap;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.Logger;

public class CustomChunkReader {
    private static final Logger logger = Journeymap.getLogger();

    public static ProcessedChunk read(ClientLevel level, ChunkPos chunkPos, CompoundTag chunkTag) {
        block10: {
            try {
                if (ChunkType.LEVELCHUNK != ChunkSerializer.getChunkTypeFromTag((CompoundTag)chunkTag)) break block10;
                DataLayer lights = null;
                boolean lightOn = chunkTag.getBoolean("isLightOn");
                ListTag sections = chunkTag.getList("sections", 10);
                int sectionsCount = level.getSectionsCount();
                LevelChunkSection[] chunkSections = new LevelChunkSection[sectionsCount];
                Registry registry = level.registryAccess().registryOrThrow(Registries.BIOME);
                Codec codec = ChunkSerializer.makeBiomeCodec((Registry)registry);
                for (int j = 0; j < sections.size(); ++j) {
                    CompoundTag section = sections.getCompound(j);
                    byte sectionTopY = section.getByte("Y");
                    int sectionIndex = level.getSectionIndexFromSectionY((int)sectionTopY);
                    try {
                        if (sectionIndex >= 0 && sectionIndex < chunkSections.length) {
                            LevelChunkSection chunkSection;
                            PalettedContainer blockStateContainer = section.contains("block_states", 10) ? (PalettedContainer)ChunkSerializer.BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)section.getCompound("block_states")).promotePartial(stringx -> ChunkSerializer.logErrors((ChunkPos)chunkPos, (int)sectionTopY, (String)stringx)).getOrThrow(ChunkSerializer.ChunkReadException::new) : new PalettedContainer((IdMap)Block.BLOCK_STATE_REGISTRY, (Object)Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES);
                            Object biomeContainer = section.contains("biomes", 10) ? (PalettedContainerRO)codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)section.getCompound("biomes")).promotePartial(stringx -> ChunkSerializer.logErrors((ChunkPos)chunkPos, (int)sectionTopY, (String)stringx)).getOrThrow(ChunkSerializer.ChunkReadException::new) : new PalettedContainer(registry.asHolderIdMap(), (Object)registry.getHolderOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES);
                            chunkSections[sectionIndex] = chunkSection = new LevelChunkSection(blockStateContainer, (PalettedContainerRO)biomeContainer);
                        }
                    }
                    catch (Exception e) {
                        throw new AutoMapChunkReaderException("Error parsing biome and block sections during automap >>", e);
                    }
                    if (!lightOn || !section.contains("BlockLight", 7)) continue;
                    byte[] lightsArray = section.getByteArray("BlockLight");
                    lights = new DataLayer(lightsArray);
                }
                LevelChunk chunkAccess = null;
                CompoundTag heightmaps = null;
                EnumSet<Heightmap.Types> heightmapEnums = null;
                try {
                    chunkAccess = new LevelChunk((Level)level, chunkPos, null, null, null, 0L, chunkSections, null, null);
                    chunkAccess.setLightCorrect(lightOn);
                    heightmaps = chunkTag.getCompound("Heightmaps");
                    heightmapEnums = EnumSet.noneOf(Heightmap.Types.class);
                }
                catch (Exception e) {
                    throw new AutoMapChunkReaderException("Error creating LevelChunk during automap", e);
                }
                for (Heightmap.Types heightmapTypes : chunkAccess.getPersistedStatus().heightmapsAfter()) {
                    String key = heightmapTypes.getSerializationKey();
                    if (heightmaps.contains(key, 12)) {
                        chunkAccess.setHeightmap(heightmapTypes, heightmaps.getLongArray(key));
                        continue;
                    }
                    heightmapEnums.add(heightmapTypes);
                }
                Heightmap.primeHeightmaps((ChunkAccess)chunkAccess, heightmapEnums);
                return new ProcessedChunk(chunkAccess, lights);
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error parsing chunk during automap >>", (Throwable)e);
            }
        }
        return null;
    }

    static class AutoMapChunkReaderException
    extends RuntimeException {
        public AutoMapChunkReaderException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public record ProcessedChunk(LevelChunk chunk, DataLayer light) {
    }
}

