/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import journeymap.client.log.JMLogger;
import journeymap.client.model.entity.EntityHelper;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.state.BoneSnapshot;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.util.RenderUtil;

public class GeckoLibHelper {
    public static EntityHelper.IconData getIconData(Entity entity) {
        GeoModel geoModel = RenderUtil.getGeoModelForEntity((Entity)entity);
        if (geoModel == null) {
            return null;
        }
        ResourceLocation modelResourceLocation = geoModel.getModelResource((GeoAnimatable)entity, null);
        String path = modelResourceLocation.getPath();
        if (path.endsWith(".geo.json")) {
            path = path.substring(0, path.length() - 9);
        } else if (path.endsWith(".json")) {
            path = path.substring(0, path.length() - 5);
        }
        if (path.startsWith("geo/")) {
            path = path.substring(4);
        }
        path = path.replace(".", "_");
        path = path.replace("/", "_");
        EntityHelper.IconData iconData = new EntityHelper.IconData();
        iconData.type = modelResourceLocation.withPath(path);
        return iconData;
    }

    public static List<ModelPart> getModelParts(Entity entity, ResourceLocation mobLocation, boolean onlyHead) {
        Optional geoBone;
        GeoModel geoModel = RenderUtil.getGeoModelForEntity((Entity)entity);
        if (geoModel == null) {
            return null;
        }
        ResourceLocation modelResourceLocation = geoModel.getModelResource((GeoAnimatable)entity, null);
        BakedGeoModel model = geoModel.getBakedModel(modelResourceLocation);
        String type = mobLocation.getPath();
        String type2 = type.substring(0, 1).toUpperCase() + type.substring(1).toLowerCase();
        if (onlyHead && (geoBone = model.getBone("head").or(() -> model.getBone("Head")).or(() -> model.getBone("heads")).or(() -> model.getBone("Heads")).or(() -> model.getBone(type)).or(() -> model.getBone(type2))).isPresent()) {
            return List.of(GeckoLibHelper.toVanillaModelPart((GeoBone)geoBone.get()));
        }
        return GeckoLibHelper.toVanillaModelParts(model.topLevelBones());
    }

    private static List<ModelPart> toVanillaModelParts(List<GeoBone> geoBones) {
        ArrayList<ModelPart> modelParts = new ArrayList<ModelPart>();
        for (GeoBone bone : geoBones) {
            modelParts.add(GeckoLibHelper.toVanillaModelPart(bone));
        }
        return modelParts;
    }

    private static ModelPart toVanillaModelPart(GeoBone geoBone) {
        PoseStack poseStack = new PoseStack();
        poseStack.mulPose(Axis.ZP.rotation((float)Math.PI));
        return GeckoLibHelper.toVanillaModelPart(poseStack, geoBone);
    }

    private static ModelPart toVanillaModelPart(PoseStack poseStack, GeoBone geoBone) {
        poseStack.pushPose();
        BoneSnapshot initial = geoBone.getInitialSnapshot();
        poseStack.translate(-initial.getOffsetX() / 16.0f, initial.getOffsetY() / 16.0f, initial.getOffsetZ() / 16.0f);
        RenderUtil.translateToPivotPoint((PoseStack)poseStack, (GeoBone)geoBone);
        if (initial.getRotZ() != 0.0f) {
            poseStack.mulPose(Axis.ZP.rotation(initial.getRotZ()));
        }
        if (initial.getRotY() != 0.0f) {
            poseStack.mulPose(Axis.YP.rotation(initial.getRotY()));
        }
        if (initial.getRotX() != 0.0f) {
            poseStack.mulPose(Axis.XP.rotation(initial.getRotX()));
        }
        poseStack.scale(initial.getScaleX(), initial.getScaleY(), initial.getScaleZ());
        RenderUtil.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoBone)geoBone);
        ArrayList<ModelPart.Cube> cubes = new ArrayList<ModelPart.Cube>();
        for (GeoCube geoCube : geoBone.getCubes()) {
            cubes.add(GeckoLibHelper.toVanillaCube(poseStack, geoCube));
        }
        HashMap children = Maps.newHashMap();
        for (GeoBone childGeoBone : geoBone.getChildBones()) {
            children.put(childGeoBone.getName(), GeckoLibHelper.toVanillaModelPart(poseStack, childGeoBone));
        }
        poseStack.popPose();
        return new ModelPart(cubes, (Map)children);
    }

    private static ModelPart.Cube toVanillaCube(PoseStack poseStack, GeoCube geoCube) {
        ModelPart.Cube cube = new ModelPart.Cube(0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 1.0f, 1.0f, EnumSet.allOf(Direction.class));
        poseStack.pushPose();
        try {
            RenderUtil.translateToPivotPoint((PoseStack)poseStack, (GeoCube)geoCube);
            RenderUtil.rotateMatrixAroundCube((PoseStack)poseStack, (GeoCube)geoCube);
            RenderUtil.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoCube)geoCube);
            Matrix3f normalisedPoseState = poseStack.last().normal();
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
            for (int quadIndex = 0; quadIndex < Math.min(geoCube.quads().length, 6); ++quadIndex) {
                Object[] vertices = new ModelPart.Vertex[4];
                Arrays.fill(vertices, new ModelPart.Vertex(0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
                cube.polygons[quadIndex] = new ModelPart.Polygon((ModelPart.Vertex[])vertices, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, false, Direction.UP);
                GeoQuad geoQuad = geoCube.quads()[quadIndex];
                if (geoQuad == null) continue;
                for (int vertexIndex = 0; vertexIndex < geoQuad.vertices().length; ++vertexIndex) {
                    GeoVertex geoVertex = geoQuad.vertices()[vertexIndex];
                    Vector3f geoPosition = geoVertex.position();
                    Vector4f position = poseState.transform(new Vector4f(geoPosition.x(), geoPosition.y(), geoPosition.z(), 1.0f));
                    position.mul(16.0f);
                    cube.polygons[quadIndex].vertices[vertexIndex] = new ModelPart.Vertex(new Vector3f(position.x(), position.y(), position.z()), geoVertex.texU(), geoVertex.texV());
                }
                Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)geoQuad.normal()));
                RenderUtil.fixInvertedFlatCube((GeoCube)geoCube, (Vector3f)normal);
                cube.polygons[quadIndex].normal.set((Vector3fc)normal);
            }
        }
        catch (Exception e) {
            JMLogger.throwLogOnce("Error getting cube", e);
        }
        poseStack.popPose();
        return cube;
    }
}

