/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal.world.level.block.behavior;

import fuzs.universalbonemeal.world.level.block.behavior.BoneMealBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FruitStemBehavior
implements BoneMealBehavior {
    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        if (!state.hasProperty((Property)StemBlock.AGE) || (Integer)state.getValue((Property)StemBlock.AGE) != 7) {
            return false;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos fruitBlockPos = pos.relative(direction);
            BlockState soilBlockState = level.getBlockState(fruitBlockPos.below());
            if (!level.isEmptyBlock(fruitBlockPos) || !(soilBlockState.getBlock() instanceof FarmBlock) && !soilBlockState.is(BlockTags.DIRT)) continue;
            return true;
        }
        return false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        while (level.getBlockState(pos) == state && random.nextInt(3) != 0) {
            state.randomTick(level, pos, random);
        }
    }
}

