/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal.world.level.block.behavior;

import fuzs.universalbonemeal.world.level.block.behavior.BoneMealBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public abstract class SpreadAwayBehavior
implements BoneMealBehavior {
    public boolean isValidBonemealTarget(LevelReader level, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState blockState) {
        this.placeOverworldGrass(level, random, pos, blockState);
    }

    private void placeOverworldGrass(ServerLevel level, RandomSource random, BlockPos pos, BlockState blockState) {
        int successes = 0;
        block0: for (int i = (this.getSpreadWidth() + 1) * 16 - 1; i >= 0; --i) {
            BlockPos currentPos = pos;
            BlockState defaultBlockState = blockState.getBlock().defaultBlockState();
            for (int j = 0; j < i / 16; ++j) {
                if (!defaultBlockState.canSurvive((LevelReader)level, currentPos = currentPos.offset(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)) || level.getBlockState(currentPos).isCollisionShapeFullBlock((BlockGetter)level, currentPos)) continue block0;
            }
            if (!level.isEmptyBlock(currentPos) || currentPos.getY() <= level.getMinBuildHeight()) continue;
            level.setBlock(currentPos, defaultBlockState, 2);
            if (++successes < this.getMostSuccesses()) continue;
            return;
        }
    }

    protected abstract int getSpreadWidth();

    protected abstract int getMostSuccesses();
}

