/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.automessage;

import com.cursee.monolib.core.sailing.Sailing;
import fabric.com.cursee.automessage.AutoMessage;
import fabric.com.cursee.automessage.Constants;
import fabric.com.cursee.automessage.core.Config;
import fabric.com.cursee.automessage.core.networking.FabricHardCountDataPayload;
import fabric.com.cursee.automessage.core.networking.FabricInitialSyncPayload;
import fabric.com.cursee.automessage.core.networking.FabricPlaytimeDataPayload;
import fabric.com.cursee.automessage.core.networking.FabricSoftCountDataPayload;
import fabric.com.cursee.automessage.core.util.PlayerData;
import fabric.com.cursee.automessage.core.util.StateSaverAndLoader;
import java.util.Arrays;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class AutoMessageFabric
implements ModInitializer {
    public static final class_2960 INITIAL_SYNC = class_2960.method_60655((String)"automessage", (String)"initial_sync");
    public static final class_2960 PLAYTIME = class_2960.method_60655((String)"automessage", (String)"playtime");
    public static final class_2960 SOFT_COUNTS = class_2960.method_60655((String)"automessage", (String)"soft_counts");
    public static final class_2960 HARD_COUNTS = class_2960.method_60655((String)"automessage", (String)"hard_counts");

    public void onInitialize() {
        AutoMessage.init();
        Sailing.register((String)"Auto Message", (String)"automessage", (String)"2.3.0", (String)"[1.21]", Constants.PUBLISHER_AUTHOR, Constants.PRIMARY_CURSEFORGE_MODRINTH);
        Config.initialize();
        PayloadTypeRegistry.playS2C().register(FabricInitialSyncPayload.ID, FabricInitialSyncPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(FabricPlaytimeDataPayload.ID, FabricPlaytimeDataPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(FabricSoftCountDataPayload.ID, FabricSoftCountDataPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(FabricHardCountDataPayload.ID, FabricHardCountDataPayload.CODEC);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            PlayerData playerState = StateSaverAndLoader.getPlayerState((class_1309)handler.method_32311());
            Arrays.fill(playerState.soft_counts, 0L);
            server.execute(() -> ServerPlayNetworking.send((class_3222)handler.method_32311(), (class_8710)new FabricInitialSyncPayload(playerState.playtime, playerState.soft_counts, playerState.hard_counts)));
        });
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            boolean oncePerSecond;
            int ticks = server.method_3780();
            boolean skipZeroth = ticks != 0;
            boolean bl = oncePerSecond = ticks % 20 == 0;
            if (Config.enabled && skipZeroth && oncePerSecond) {
                for (class_3222 player : server.method_3760().method_14571()) {
                    PlayerData playerData = StateSaverAndLoader.getPlayerState((class_1309)player);
                    ++playerData.playtime;
                    for (int i = 0; i < Config.messages.size(); ++i) {
                        boolean flag_HardUnlimited;
                        int messageIndex = i;
                        int getPlaytime = playerData.playtime;
                        long[] softCounts = playerData.soft_counts;
                        long[] hardCounts = playerData.hard_counts;
                        long softCountAtMessageIndex = softCounts[messageIndex];
                        long hardCountAtMessageIndex = hardCounts[messageIndex];
                        String possibleMessage = Config.messages.get(messageIndex);
                        String possibleLink = Config.links.get(messageIndex);
                        boolean flag_HasMessage = !possibleMessage.isEmpty() && !possibleMessage.isBlank();
                        boolean flag_HasLink = !possibleLink.isEmpty() && !possibleLink.isBlank();
                        boolean flag_PlaytimeHittingInterval = getPlaytime % Math.toIntExact(Config.intervals.get(messageIndex)) == 0;
                        boolean flag_SoftLessThanLimit = softCountAtMessageIndex < (long)Math.toIntExact(Config.soft_limits.get(messageIndex));
                        boolean flag_SoftUnlimited = Math.toIntExact(Config.soft_limits.get(messageIndex)) == 0;
                        boolean flag_HardLessThanLimit = hardCountAtMessageIndex < (long)Math.toIntExact(Config.hard_limits.get(messageIndex));
                        boolean bl2 = flag_HardUnlimited = Math.toIntExact(Config.hard_limits.get(messageIndex)) == 0;
                        if (!flag_HasMessage || !flag_PlaytimeHittingInterval || !flag_SoftLessThanLimit && !flag_SoftUnlimited || !flag_HardLessThanLimit && !flag_HardUnlimited) continue;
                        if (flag_HasLink) {
                            player.method_43496((class_2561)class_2561.method_43470((String)possibleMessage).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, possibleLink))));
                        } else {
                            player.method_43496((class_2561)class_2561.method_43470((String)possibleMessage));
                        }
                        playerData.incrementSoftCounterAtIndex(messageIndex);
                        playerData.incrementHardCounterAtIndex(messageIndex);
                    }
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new FabricPlaytimeDataPayload(playerData.playtime));
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new FabricSoftCountDataPayload(playerData.soft_counts));
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new FabricHardCountDataPayload(playerData.hard_counts));
                }
            }
        });
    }
}

