/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.automessage;

import com.cursee.monolib.core.sailing.Sailing;
import forge.com.cursee.automessage.AutoMessage;
import forge.com.cursee.automessage.Constants;
import forge.com.cursee.automessage.core.Config;
import forge.com.cursee.automessage.core.capability.MessagingCapability;
import forge.com.cursee.automessage.core.capability.MessagingProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="automessage")
public class AutoMessageForge {
    public AutoMessageForge() {
        AutoMessage.init();
        Sailing.register((String)"Auto Message", (String)"automessage", (String)"2.3.0", (String)"[1.21]", Constants.PUBLISHER_AUTHOR, Constants.PRIMARY_CURSEFORGE_MODRINTH);
        Config.initialize();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::onRegisterCapabilitiesEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onRegisterCapabilitiesEvent(RegisterCapabilitiesEvent event) {
        event.register(MessagingCapability.class);
    }

    @SubscribeEvent
    public void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(MessagingProvider.PLAYER_MESSAGING_CAPABILITY).isPresent()) {
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"automessage", (String)"properties"), (ICapabilityProvider)new MessagingProvider());
        }
    }

    @SubscribeEvent
    public void onStartTick(TickEvent.ServerTickEvent event) {
        boolean flag_OperatingOncePerSecond;
        boolean flag_StartOfTick = event.phase == TickEvent.Phase.START;
        boolean flag_SkipZeroTick = event.getServer().getTickCount() != 0;
        boolean bl = flag_OperatingOncePerSecond = event.getServer().getTickCount() % 20 == 0;
        if (flag_StartOfTick && flag_SkipZeroTick && flag_OperatingOncePerSecond) {
            for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
                player.getCapability(MessagingProvider.PLAYER_MESSAGING_CAPABILITY).ifPresent(messaging -> {
                    messaging.incrementPlaytime();
                    for (int i = 0; i < Config.messages.size(); ++i) {
                        int messageIndex = i;
                        boolean flag_PlaytimeHittingInterval = (long)messaging.getPlaytime() % Config.intervals.get(messageIndex) == 0L;
                        boolean flag_SoftLessThanLimit = (long)messaging.getSoftCounts()[messageIndex] < Config.soft_limits.get(messageIndex);
                        boolean flag_SoftUnlimited = Config.soft_limits.get(messageIndex) == 0L;
                        boolean flag_HardLessThanLimit = (long)messaging.getHardCounts()[messageIndex] < Config.hard_limits.get(messageIndex);
                        boolean flag_HardUnlimited = Config.hard_limits.get(messageIndex) == 0L;
                        boolean flag_Enabled = Config.enabled;
                        if (!flag_PlaytimeHittingInterval || !flag_SoftLessThanLimit && !flag_SoftUnlimited || !flag_HardLessThanLimit && !flag_HardUnlimited || !flag_Enabled) continue;
                        player.sendSystemMessage((Component)Component.literal((String)Config.messages.get(messageIndex)).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, String.valueOf(Config.links.get(messageIndex))))));
                        messaging.incrementSoftCountAtIndex(messageIndex);
                        messaging.incrementHardCountAtIndex(messageIndex);
                    }
                });
            }
        }
    }

    @Mod.EventBusSubscriber(modid="automessage")
    public static class ModEvents {
        @SubscribeEvent
        public static void onPlayerCloned(PlayerEvent.Clone event) {
            Player original = event.getOriginal();
            if (event.isWasDeath()) {
                original.reviveCaps();
                original.getCapability(MessagingProvider.PLAYER_MESSAGING_CAPABILITY).ifPresent(oldStore -> event.getEntity().getCapability(MessagingProvider.PLAYER_MESSAGING_CAPABILITY).ifPresent(newStore -> newStore.copyFrom((MessagingCapability)oldStore)));
                original.invalidateCaps();
            }
        }
    }
}

