/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.automessage;

import com.cursee.monolib.core.sailing.Sailing;
import neoforge.com.cursee.automessage.AutoMessage;
import neoforge.com.cursee.automessage.Constants;
import neoforge.com.cursee.automessage.config.Config;
import neoforge.com.cursee.automessage.neocommon.capability.AutoMessageProperties;
import neoforge.com.cursee.automessage.neonetwork.Networking;
import neoforge.com.cursee.automessage.neoregistry.AutoMessageDataStorage;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@Mod(value="automessage")
public class NeoForgeExampleMod {
    public static NeoForgeExampleMod INSTANCE;

    public NeoForgeExampleMod(IEventBus bus) {
        Constants.LOG.info("Hello NeoForge world!");
        AutoMessage.init();
        Sailing.register((String)"Auto Message", (String)"automessage", (String)"2.3.0", (String)"[1.21]", Constants.PUBLISHER_AUTHOR, Constants.PRIMARY_CURSEFORGE_MODRINTH);
        Config.initialize();
        INSTANCE = this;
        AutoMessageDataStorage.ATTACHMENT_TYPES.register(bus);
        bus.addListener(Networking::register);
        NeoForge.EVENT_BUS.addListener(AutoMessageDataStorage::onPlayerClone);
        NeoForge.EVENT_BUS.addListener(AutoMessageDataStorage::onJoinWorld);
    }

    @EventBusSubscriber(modid="automessage", bus=EventBusSubscriber.Bus.GAME)
    public static class NeoEventBusListeners {
        @SubscribeEvent
        public static void onStartTick(ServerTickEvent.Pre event) {
            for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
                boolean flag_OperatingOncePerSecond;
                boolean flag_SkipZeroTick = event.getServer().getTickCount() != 0;
                boolean bl = flag_OperatingOncePerSecond = event.getServer().getTickCount() % 20 == 0;
                if (!flag_SkipZeroTick || !flag_OperatingOncePerSecond || !player.hasData(AutoMessageDataStorage.PROPERTIES)) continue;
                AutoMessageProperties messaging = (AutoMessageProperties)player.getData(AutoMessageDataStorage.PROPERTIES);
                messaging.incrementPlaytime();
                for (int i = 0; i < Config.messages.size(); ++i) {
                    int messageIndex = i;
                    boolean flag_PlaytimeHittingInterval = (long)messaging.getPlaytime() % Config.intervals.get(messageIndex) == 0L;
                    boolean flag_SoftLessThanLimit = messaging.getSoftCounts()[messageIndex] < Config.soft_limits.get(messageIndex);
                    boolean flag_SoftUnlimited = Config.soft_limits.get(messageIndex) == 0L;
                    boolean flag_HardLessThanLimit = messaging.getHardCounts()[messageIndex] < Config.hard_limits.get(messageIndex);
                    boolean flag_HardUnlimited = Config.hard_limits.get(messageIndex) == 0L;
                    boolean flag_Enabled = Config.enabled;
                    if (!flag_PlaytimeHittingInterval || !flag_SoftLessThanLimit && !flag_SoftUnlimited || !flag_HardLessThanLimit && !flag_HardUnlimited || !flag_Enabled) continue;
                    player.sendSystemMessage((Component)Component.literal((String)Config.messages.get(messageIndex)).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, String.valueOf(Config.links.get(messageIndex))))));
                    messaging.incrementSoftCountAtIndex(messageIndex);
                    messaging.incrementHardCountAtIndex(messageIndex);
                }
            }
        }
    }
}

