/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.ChestState;
import xfacthd.framedblocks.common.data.property.LatchType;

public class FramedChestGeometry
extends Geometry {
    private final BlockState state;
    private final BakedModel baseModel;
    private final Direction facing;
    private final ChestType type;
    private final boolean closed;
    private final LatchType latch;
    private final ChunkRenderTypeSet addLayers;

    public FramedChestGeometry(GeometryFactory.Context ctx) {
        this.state = ctx.state();
        this.baseModel = ctx.baseModel();
        this.facing = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.type = (ChestType)ctx.state().getValue((Property)BlockStateProperties.CHEST_TYPE);
        this.closed = ctx.state().getValue(PropertyHolder.CHEST_STATE) == ChestState.CLOSED;
        this.latch = (LatchType)((Object)ctx.state().getValue(PropertyHolder.LATCH_TYPE));
        this.addLayers = this.latch == LatchType.DEFAULT ? ModelUtils.CUTOUT : ChunkRenderTypeSet.none();
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing.getAxis(), 0.9375f)).applyIf(Modifiers.cutTopBottom(this.facing.getClockWise(), 0.9375f), this.type != ChestType.LEFT).applyIf(Modifiers.cutTopBottom(this.facing.getCounterClockWise(), 0.9375f), this.type != ChestType.RIGHT).applyIf(Modifiers.setPosition(this.closed ? 0.875f : 0.625f), quadDir == Direction.UP).export(quadMap.get(quadDir == Direction.UP ? null : quadDir));
        } else if (quadDir.getAxis() == this.facing.getAxis()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, this.closed ? 0.875f : 0.625f)).applyIf(Modifiers.cutSideLeftRight(this.facing.getClockWise(), 0.9375f), this.type != ChestType.LEFT).applyIf(Modifiers.cutSideLeftRight(this.facing.getCounterClockWise(), 0.9375f), this.type != ChestType.RIGHT).apply(Modifiers.setPosition(0.9375f)).export(quadMap.get(null));
        } else {
            boolean offset = !(this.type == ChestType.RIGHT && quadDir == this.facing.getCounterClockWise() || this.type == ChestType.LEFT && quadDir == this.facing.getClockWise());
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, this.closed ? 0.875f : 0.625f)).apply(Modifiers.cutSideLeftRight(0.9375f)).applyIf(Modifiers.setPosition(0.9375f), offset).export(quadMap.get(offset ? null : quadDir));
        }
        if (this.latch == LatchType.CAMO && this.closed) {
            FramedChestGeometry.makeChestLatch(quadMap, quad, this.facing, this.type);
        }
    }

    public static void makeChestLatch(QuadMap quadMap, BakedQuad quad, Direction facing, ChestType type) {
        float length;
        Direction face = quad.getDirection();
        float f = length = type == ChestType.SINGLE ? 0.5625f : 0.0625f;
        if (face == facing || face == facing.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.5625f)).apply(Modifiers.cutSideUpDown(false, 0.6875f)).applyIf(Modifiers.cutSideLeftRight(facing.getClockWise(), length), type != ChestType.LEFT).applyIf(Modifiers.cutSideLeftRight(facing.getCounterClockWise(), length), type != ChestType.RIGHT).applyIf(Modifiers.setPosition(0.0625f), face != facing).export(quadMap.get((Direction)(face == facing ? facing : null)));
        } else if (Utils.isY(face)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(facing.getOpposite(), 0.0625f)).applyIf(Modifiers.cutTopBottom(facing.getClockWise(), length), type != ChestType.LEFT).applyIf(Modifiers.cutTopBottom(facing.getCounterClockWise(), length), type != ChestType.RIGHT).apply(Modifiers.setPosition(face == Direction.UP ? 0.6875f : 0.5625f)).export(quadMap.get(null));
        } else {
            boolean offset = !(type == ChestType.RIGHT && face == facing.getCounterClockWise() || type == ChestType.LEFT && face == facing.getClockWise());
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.0f, 0.4375f, 1.0f, 0.6875f)).apply(Modifiers.cutSideLeftRight(facing.getOpposite(), 0.0625f)).applyIf(Modifiers.setPosition(length), offset).export(quadMap.get(offset ? null : face));
        }
    }

    @Override
    public ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return this.addLayers;
    }

    @Override
    public void getAdditionalQuads(QuadMap quadMap, RandomSource rand, ModelData data, RenderType renderType) {
        if (!this.closed || this.latch != LatchType.DEFAULT) {
            return;
        }
        List quads = this.baseModel.getQuads(this.state, null, rand, data, renderType);
        for (BakedQuad quad : quads) {
            quadMap.get(null).add(quad);
        }
    }
}

