/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.interactive;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedHopperGeometry
extends Geometry {
    private final Direction facing;

    public FramedHopperGeometry(GeometryFactory.Context ctx) {
        this.facing = (Direction)ctx.state().getValue((Property)HopperBlock.FACING);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir) && this.facing != Direction.DOWN) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing.getOpposite(), 0.25f)).apply(Modifiers.cutTopBottom(this.facing.getClockWise().getAxis(), 0.625f)).apply(Modifiers.setPosition(quadDir == Direction.UP ? 0.5f : 0.75f)).export(quadMap.get(null));
        }
        if (quadDir == Direction.UP) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.NORTH, 0.125f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.SOUTH, 0.125f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.Axis.Z, 0.875f)).apply(Modifiers.cutTopBottom(Direction.EAST, 0.125f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.Axis.Z, 0.875f)).apply(Modifiers.cutTopBottom(Direction.WEST, 0.125f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.125f, 0.125f, 0.875f, 0.875f)).apply(Modifiers.setPosition(0.6875f)).export(quadMap.get(null));
        } else if (quadDir == Direction.DOWN) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.NORTH, 0.25f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.SOUTH, 0.25f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.Axis.Z, 0.75f)).apply(Modifiers.cutTopBottom(Direction.EAST, 0.25f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.Axis.Z, 0.75f)).apply(Modifiers.cutTopBottom(Direction.WEST, 0.25f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.25f, 0.25f, 0.75f, 0.75f)).apply(Modifiers.setPosition(0.75f)).export(quadMap.get(null));
            if (this.facing == Direction.DOWN) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.375f, 0.375f, 0.625f, 0.625f)).export(quadMap.get(null));
            }
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.375f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.25f, 0.25f, 0.75f, 0.625f)).apply(Modifiers.setPosition(0.75f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.3125f)).apply(Modifiers.cutSideLeftRight(0.875f)).apply(Modifiers.setPosition(0.125f)).export(quadMap.get(null));
            if (this.facing == Direction.DOWN) {
                QuadModifier.of(quad).apply(Modifiers.cutSide(0.375f, 0.0f, 0.625f, 0.25f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
            } else if (quadDir == this.facing) {
                QuadModifier.of(quad).apply(Modifiers.cutSide(0.375f, 0.25f, 0.625f, 0.5f)).export(quadMap.get(quadDir));
            } else if (quadDir.getAxis() == this.facing.getClockWise().getAxis()) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.facing.getOpposite(), 0.25f)).apply(Modifiers.cutSideUpDown(true, 0.75f)).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
            }
        }
    }

    @Override
    public boolean useSolidNoCamoModel() {
        return true;
    }
}

