/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.cullupdate;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import xfacthd.framedblocks.common.net.payload.ClientboundCullingUpdatePayload;

public final class CullingUpdateTracker {
    private static final Map<ResourceKey<Level>, Long2ObjectMap<LongSet>> UPDATED_POSITIONS = new Reference2ObjectOpenHashMap();

    public static void onServerLevelTick(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        ResourceKey dim = level.dimension();
        Long2ObjectMap<LongSet> chunks = UPDATED_POSITIONS.get(dim);
        if (chunks != null && !chunks.isEmpty()) {
            for (Long2ObjectMap.Entry entry : chunks.long2ObjectEntrySet()) {
                long chunk = entry.getLongKey();
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(chunk), (CustomPacketPayload)new ClientboundCullingUpdatePayload(chunk, (LongSet)entry.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            chunks.clear();
        }
    }

    public static void onServerShutdown(ServerStoppedEvent event) {
        UPDATED_POSITIONS.clear();
    }

    public static void enqueueCullingUpdate(Level level, BlockPos pos) {
        ((LongSet)UPDATED_POSITIONS.computeIfAbsent((ResourceKey<Level>)level.dimension(), $ -> new Long2ObjectOpenHashMap()).computeIfAbsent(ChunkPos.asLong((BlockPos)pos), $ -> new LongArraySet())).add(pos.asLong());
    }

    private CullingUpdateTracker() {
    }
}

