/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopeedge;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.misc.MiscDirs;
import xfacthd.framedblocks.common.data.skippreds.pillar.PillarDirs;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabDirs;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeDirs;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.SlopeEdgeDirs;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelDirs;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SlopePanelCornerDirs;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabDirs;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsDirs;

@CullTest(value={BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE})
public final class InnerCornerSlopeEdgeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            CornerType type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
            boolean alt = (Boolean)state.getValue((Property)PropertyHolder.ALT_TYPE);
            return switch (blockType) {
                case BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstInnerCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstHalfSlope(dir, type, alt, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_SLOPE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstVerticalHalfSlope(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SLOPE_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstElevatedSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_CORNER_SLOPE_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstElevatedCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_ELEVATED_INNER_CORNER_SLOPE_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstElevatedInnerCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_THREEWAY_CORNER_SLOPE_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstThreewayCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_INNER_THREEWAY_CORNER_SLOPE_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstInnerThreewayCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SLAB -> InnerCornerSlopeEdgeSkipPredicate.testAgainstSlab(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstSlabEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_PANEL -> InnerCornerSlopeEdgeSkipPredicate.testAgainstPanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> InnerCornerSlopeEdgeSkipPredicate.testAgainstCornerPillar(dir, type, alt, adjState, side);
                case BlockType.FRAMED_STAIRS -> InnerCornerSlopeEdgeSkipPredicate.testAgainstStairs(dir, type, alt, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> InnerCornerSlopeEdgeSkipPredicate.testAgainstHalfStairs(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> InnerCornerSlopeEdgeSkipPredicate.testAgainstSlopedStairs(dir, type, alt, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> InnerCornerSlopeEdgeSkipPredicate.testAgainstVerticalStairs(dir, type, alt, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> InnerCornerSlopeEdgeSkipPredicate.testAgainstVerticalHalfStairs(dir, type, alt, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> InnerCornerSlopeEdgeSkipPredicate.testAgainstVerticalSlopedStairs(dir, type, alt, adjState, side);
                case BlockType.FRAMED_THREEWAY_CORNER_PILLAR -> InnerCornerSlopeEdgeSkipPredicate.testAgainstThreewayCornerPillar(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> InnerCornerSlopeEdgeSkipPredicate.testAgainstSlopeSlab(dir, type, alt, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> InnerCornerSlopeEdgeSkipPredicate.testAgainstElevatedSlopeSlab(dir, type, alt, adjState, side);
                case BlockType.FRAMED_COMPOUND_SLOPE_SLAB -> InnerCornerSlopeEdgeSkipPredicate.testAgainstCompoundSlopeSlab(dir, type, alt, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> InnerCornerSlopeEdgeSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, type, alt, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> InnerCornerSlopeEdgeSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> InnerCornerSlopeEdgeSkipPredicate.testAgainstSlopePanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> InnerCornerSlopeEdgeSkipPredicate.testAgainstExtendedSlopePanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_COMPOUND_SLOPE_PANEL -> InnerCornerSlopeEdgeSkipPredicate.testAgainstCompoundSlopePanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> InnerCornerSlopeEdgeSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, type, alt, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> InnerCornerSlopeEdgeSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, type, alt, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL -> InnerCornerSlopeEdgeSkipPredicate.testAgainstLargeCornerSlopePanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W -> InnerCornerSlopeEdgeSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, type, alt, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL -> InnerCornerSlopeEdgeSkipPredicate.testAgainstLargeInnerCornerSlopePanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W -> InnerCornerSlopeEdgeSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, type, alt, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL -> InnerCornerSlopeEdgeSkipPredicate.testAgainstExtendedInnerCornerSlopePanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W -> InnerCornerSlopeEdgeSkipPredicate.testAgainstExtendedInnerCornerSlopePanelWall(dir, type, alt, adjState, side);
                case BlockType.FRAMED_ELEVATED_PYRAMID_SLAB -> InnerCornerSlopeEdgeSkipPredicate.testAgainstElevatedPyramidSlab(dir, type, alt, adjState, side);
                case BlockType.FRAMED_MASONRY_CORNER_SEGMENT -> InnerCornerSlopeEdgeSkipPredicate.testAgainstMasonryCornerSegment(dir, type, alt, adjState, side);
                case BlockType.FRAMED_LAYERED_CUBE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstLayeredCube(dir, type, alt, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getTriDir(dir, type, alt, side).isEqualTo(SlopeEdgeDirs.InnerCornerSlopeEdge.getTriDir(adjDir, adjType, adjAlt, side.getOpposite())) || SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite())) || SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(dir, type, alt, side).isEqualTo(SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstHalfSlope(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopeDirs.HalfSlope.getHalfDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalHalfSlope(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopeDirs.VerticalHalfSlope.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_EDGE})
    private static boolean testAgainstSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getTriDir(dir, type, alt, side).isEqualTo(SlopeEdgeDirs.SlopeEdge.getTriDir(adjDir, adjType, adjAlt, side.getOpposite())) || SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopeEdgeDirs.SlopeEdge.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_EDGE})
    private static boolean testAgainstElevatedSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getTriDir(dir, type, alt, side).isEqualTo(SlopeEdgeDirs.CornerSlopeEdge.getTriDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedInnerCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(dir, type, alt, side).isEqualTo(SlopeEdgeDirs.ElevatedInnerCornerSlopeEdge.getStairDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THREEWAY_CORNER_SLOPE_EDGE})
    private static boolean testAgainstThreewayCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getTriDir(dir, type, alt, side).isEqualTo(SlopeEdgeDirs.ThreewayCornerSlopeEdge.getTriDir(adjDir, adjTop, adjRight, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_THREEWAY_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerThreewayCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getTriDir(dir, type, alt, side).isEqualTo(SlopeEdgeDirs.InnerThreewayCornerSlopeEdge.getTriDir(adjDir, adjTop, adjRight, adjAlt, side.getOpposite())) || SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(dir, type, alt, side).isEqualTo(SlopeEdgeDirs.InnerThreewayCornerSlopeEdge.getStairDir(adjDir, adjTop, adjRight, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB})
    private static boolean testAgainstSlab(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlabDirs.Slab.getHalfDir(adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlabDirs.SlabEdge.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PANEL})
    private static boolean testAgainstPanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlabDirs.Panel.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstCornerPillar(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(PillarDirs.CornerPillar.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        StairsShape adjShape = (StairsShape)adjState.getValue((Property)BlockStateProperties.STAIRS_SHAPE);
        Half adjHalf = (Half)adjState.getValue((Property)BlockStateProperties.HALF);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(StairsDirs.Stairs.getHalfDir(adjDir, adjShape, adjHalf, side.getOpposite())) || SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(dir, type, alt, side).isEqualTo(StairsDirs.Stairs.getStairDir(adjDir, adjShape, adjHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(StairsDirs.HalfStairs.getHalfDir(adjDir, adjTop, adjRight, side.getOpposite())) || SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(dir, type, alt, side).isEqualTo(StairsDirs.HalfStairs.getStairDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPED_STAIRS})
    private static boolean testAgainstSlopedStairs(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(StairsDirs.SlopedStairs.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.getValue(PropertyHolder.STAIRS_TYPE));
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(StairsDirs.VerticalStairs.getHalfDir(adjDir, adjType, side.getOpposite())) || SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(dir, type, alt, side).isEqualTo(StairsDirs.VerticalStairs.getStairDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(StairsDirs.VerticalHalfStairs.getHalfDir(adjDir, adjTop, side.getOpposite())) || SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(dir, type, alt, side).isEqualTo(StairsDirs.VerticalHalfStairs.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_SLOPED_STAIRS})
    private static boolean testAgainstVerticalSlopedStairs(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(StairsDirs.VerticalSlopedStairs.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THREEWAY_CORNER_PILLAR})
    private static boolean testAgainstThreewayCornerPillar(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(dir, type, alt, side).isEqualTo(PillarDirs.ThreewayCornerPillar.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstSlopeSlab(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopeSlabDirs.SlopeSlab.getHalfDir(adjDir, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_SLAB})
    private static boolean testAgainstElevatedSlopeSlab(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopeSlabDirs.ElevatedSlopeSlab.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_COMPOUND_SLOPE_SLAB})
    private static boolean testAgainstCompoundSlopeSlab(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopeSlabDirs.CompoundSlopeSlab.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatInnerSlopeSlabCorner(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(adjDir, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedSlopeSlabCorner(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopeSlabDirs.FlatElevatedSlopeSlabCorner.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstSlopePanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopePanelDirs.SlopePanel.getHalfDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXTENDED_SLOPE_PANEL})
    private static boolean testAgainstExtendedSlopePanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopePanelDirs.ExtendedSlopePanel.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_COMPOUND_SLOPE_PANEL})
    private static boolean testAgainstCompoundSlopePanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopePanelDirs.CompoundSlopePanel.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInnerSlopePanelCorner(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopePanelDirs.FlatInnerSlopePanelCorner.getHalfDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedSlopePanelCorner(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopePanelDirs.FlatExtendedSlopePanelCorner.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeCornerSlopePanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(dir, type, alt, side).isEqualTo(SlopePanelCornerDirs.LargeCornerSlopePanel.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeCornerSlopePanelWall(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(dir, type, alt, side).isEqualTo(SlopePanelCornerDirs.LargeCornerSlopePanelWall.getStairDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeInnerCornerSlopePanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(dir, type, alt, side).isEqualTo(SlopePanelCornerDirs.LargeInnerCornerSlopePanel.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeInnerCornerSlopePanelWall(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(dir, type, alt, side).isEqualTo(SlopePanelCornerDirs.LargeInnerCornerSlopePanelWall.getStairDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerCornerSlopePanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(dir, type, alt, side).isEqualTo(SlopePanelCornerDirs.ExtendedInnerCornerSlopePanel.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerCornerSlopePanelWall(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(dir, type, alt, side).isEqualTo(SlopePanelCornerDirs.ExtendedInnerCornerSlopePanelWall.getStairDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_PYRAMID_SLAB})
    private static boolean testAgainstElevatedPyramidSlab(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlopeDirs.ElevatedPyramidSlab.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_MASONRY_CORNER_SEGMENT})
    private static boolean testAgainstMasonryCornerSegment(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(SlabDirs.MasonryCornerSegment.getHalfDir(adjDir, adjTop, side.getOpposite())) || SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(dir, type, alt, side).isEqualTo(SlabDirs.MasonryCornerSegment.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LAYERED_CUBE})
    private static boolean testAgainstLayeredCube(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjFacing = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        int adjLayers = (Integer)adjState.getValue((Property)BlockStateProperties.LAYERS);
        return SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(dir, type, alt, side).isEqualTo(MiscDirs.LayeredCube.getHalfDir(adjFacing, adjLayers, side.getOpposite()));
    }
}

