/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.access;

import java.util.Objects;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.level.block.state.BlockState;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;

public class EntityDetailsBodyProvider
implements IEntityComponentProvider {
    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        Leashable leashable;
        String key;
        Armadillo armadillo;
        Axolotl axolotl;
        TamableAnimal animal;
        if (!config.get(JadeIds.ACCESS_ENTITY_DETAILS)) {
            return;
        }
        Entity entity = accessor.getEntity();
        int poseId = entity.getPose().id();
        if (entity instanceof TamableAnimal && (animal = (TamableAnimal)entity).isInSittingPose()) {
            poseId = Pose.SITTING.id();
        } else if (entity instanceof Fox) {
            Fox fox = (Fox)entity;
            if (fox.isSleeping()) {
                poseId = Pose.SLEEPING.id();
            } else if (fox.isSitting()) {
                poseId = Pose.SITTING.id();
            }
        } else if (entity instanceof Axolotl && (axolotl = (Axolotl)entity).isPlayingDead()) {
            poseId = 1000;
        } else if (entity instanceof Armadillo && (armadillo = (Armadillo)entity).getState() == Armadillo.ArmadilloState.ROLLING) {
            poseId = 1001;
        }
        if (poseId != Pose.STANDING.id() && I18n.exists((String)(key = "jade.access.entity.pose.%s".formatted(poseId)))) {
            tooltip.add((Component)Component.translatable((String)"jade.access.entity.pose", (Object[])new Object[]{Component.translatable((String)key)}));
        }
        if (entity instanceof Leashable && (leashable = (Leashable)entity).isLeashed()) {
            Entity holder = leashable.getLeashHolder();
            if (holder instanceof LeashFenceKnotEntity) {
                LeashFenceKnotEntity knot = (LeashFenceKnotEntity)holder;
                BlockState blockState = Objects.requireNonNull(knot.level()).getBlockState(knot.blockPosition());
                tooltip.add((Component)Component.translatable((String)"jade.access.entity.leashed_to", (Object[])new Object[]{blockState.getBlock().getName()}));
            } else if (holder != null) {
                tooltip.add((Component)Component.translatable((String)"jade.access.entity.leashed_to", (Object[])new Object[]{holder.getName()}));
            }
        }
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.ACCESS_ENTITY_DETAILS_BODY;
    }

    @Override
    public boolean isRequired() {
        return true;
    }
}

