/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.blocks;

import com.kyanite.deeperdarker.util.DDDamageTypes;
import com.kyanite.deeperdarker.util.DDTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SculkJawBlock
extends Block {
    public static final BooleanProperty BITING = BooleanProperty.create((String)"biting");
    public static final BooleanProperty CAN_BITE = BooleanProperty.create((String)"can_bite");

    public SculkJawBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BITING, (Comparable)Boolean.valueOf(false))).setValue((Property)CAN_BITE, (Comparable)Boolean.valueOf(true)));
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        Monster monster;
        Player player;
        if (entity instanceof Player && ((player = (Player)entity).isCreative() || player.isCrouching())) {
            return;
        }
        if (entity instanceof Monster && (monster = (Monster)entity).getType().is(DDTags.Misc.SCULK)) {
            return;
        }
        if (((Boolean)state.getValue((Property)CAN_BITE)).booleanValue() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            level.setBlock(pos, (BlockState)state.setValue((Property)BITING, (Comparable)Boolean.valueOf(true)), 3);
            living.hurt(DDDamageTypes.source(level, DDDamageTypes.BITE, (Entity)living, null), 3.0f);
            if (living instanceof Player) {
                Player player2 = (Player)living;
                player2.giveExperiencePoints(-4);
            }
            level.scheduleTick(pos, (Block)this, 35);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)BITING)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITING, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.hurt(DDDamageTypes.source(level, DDDamageTypes.BITE, (Entity)living, null), 3.0f);
        }
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)BITING) != false ? Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0) : super.getCollisionShape(state, level, pos, context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BITING, CAN_BITE});
    }
}

