/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.client.dialog;

import bagu_chan.bagus_lib.client.dialog.DialogOption;
import bagu_chan.bagus_lib.register.ModDialogs;
import bagu_chan.bagus_lib.util.DialogHandler;
import bagu_chan.bagus_lib.util.client.SoundUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class DialogType {
    public static final MapCodec<DialogType> CODEC = RecordCodecBuilder.mapCodec(p_345644_ -> p_345644_.group((App)Codec.STRING.fieldOf("dialog").forGetter(DialogType::getDialogueBase), (App)DialogOption.CODEC.fieldOf("dialog_option").orElse((Object)new DialogOption(1.0f, 1.0f, true, Optional.empty())).forGetter(DialogType::getDialogueOption), (App)Codec.LONG.fieldOf("dialog_render_time").forGetter(DialogType::getDialogRenderTime), (App)Codec.DOUBLE.fieldOf("draw_per_tick").forGetter(DialogType::getDialogPerTick)).apply((Applicative)p_345644_, DialogType::new));
    public static final Codec<DialogType> DIRECT_CODEC = ModDialogs.getRegistry().byNameCodec().dispatch(DialogType::codec, Function.identity());
    @Nullable
    protected DialogHandler.DrawString drawingString;
    protected final String dialogueBase;
    protected final DialogOption dialogueOption;
    protected final long dialogRenderTime;
    protected long lastDialogRenderTime;
    protected final double dialogPerTick;

    public DialogType(String dialogueBase, DialogOption dialogueOption, long dialogRenderTime, double dialogPerTick) {
        this.dialogueBase = dialogueBase;
        this.dialogueOption = dialogueOption;
        this.dialogRenderTime = dialogRenderTime;
        this.dialogPerTick = dialogPerTick;
    }

    public MapCodec<? extends DialogType> codec() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics guiGraphics, PoseStack poseStack, float f, float tickCount, int y) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderText(GuiGraphics guiGraphics, PoseStack poseStack, float f, float tickCount, int y) {
        Font font = Minecraft.getInstance().font;
        float g = tickCount + f;
        if (this.drawingString == null && this.dialogueBase != null) {
            MutableComponent component = this.dialogueOption.translate() ? Component.translatable((String)this.dialogueBase) : Component.literal((String)this.dialogueBase);
            this.drawingString = this.beginString(guiGraphics, g, this.dialogPerTick, font, component.getString(), 0xFFFFFF, guiGraphics.guiWidth() - 72);
        }
        if (this.drawingString != null && this.drawingString.draw(g, 72, y) && this.dialogueOption.soundEvent().isPresent()) {
            SoundUtils.playClientSound(this.dialogueOption.soundEvent().get());
        }
    }

    public DialogHandler.DrawString beginString(GuiGraphics guiGraphics, double lastTick, double perTick, Font font, String string2, int i, int j2) {
        List list = font.getSplitter().splitLines(string2, j2, Style.EMPTY);
        String string22 = list.stream().map(FormattedText::getString).collect(Collectors.joining("\n"));
        return new DialogHandler.DrawString(lastTick, perTick, string22, (string, j, k) -> {
            String[] strings = string.split("\\r?\\n");
            int l = k;
            for (String string3 : strings) {
                guiGraphics.drawString(font, string3, j, l, i);
                Objects.requireNonNull(font);
                l += 9 + 4;
            }
        });
    }

    @Nullable
    public String getDialogueBase() {
        return this.dialogueBase;
    }

    public DialogOption getDialogueOption() {
        return this.dialogueOption;
    }

    public long getDialogRenderTime() {
        return this.dialogRenderTime;
    }

    public double getDialogPerTick() {
        return this.dialogPerTick;
    }

    public void setLastDialogRenderTime(long lastDialogRenderTime) {
        this.lastDialogRenderTime = lastDialogRenderTime;
    }

    public long getLastDialogRenderTime() {
        return this.lastDialogRenderTime;
    }
}

