/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.entity.navigator.node;

import bagu_chan.bagus_lib.entity.ISmartJump;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SmartNodeEvaluator
extends WalkNodeEvaluator {
    private final Object2BooleanMap<AABB> collisionCache = new Object2BooleanOpenHashMap();

    public void done() {
        this.collisionCache.clear();
        super.done();
    }

    @Nullable
    protected Node findAcceptedNode(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, Direction direction, PathType pathType) {
        Node node = null;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        double d0 = this.getFloorLevel((BlockPos)blockpos$mutableblockpos.set(x, y, z));
        if (d0 - nodeFloorLevel > this.getMobJumpHeight()) {
            return null;
        }
        PathType pathtype = this.getCachedPathType(x, y, z);
        float f = this.mob.getPathfindingMalus(pathtype);
        if (f >= 0.0f) {
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathtype, f);
        }
        if (SmartNodeEvaluator.doesBlockHavePartialCollision(pathType) && node != null && node.costMalus >= 0.0f && !this.canReachWithoutCollision(node)) {
            node = null;
        }
        if (!(pathtype == PathType.WALKABLE || this.isAmphibious() && pathtype == PathType.WATER)) {
            if ((node == null || node.costMalus < 0.0f) && verticalDeltaLimit > 0 && (pathtype != PathType.FENCE || this.canWalkOverFences()) && pathtype != PathType.UNPASSABLE_RAIL && pathtype != PathType.TRAPDOOR && pathtype != PathType.POWDER_SNOW) {
                for (int height = 0; height < Mth.floor((double)this.getMobJumpHeight()); ++height) {
                    if (node != null) continue;
                    node = this.tryJumpOn(x, y + height, z, verticalDeltaLimit, nodeFloorLevel, direction, pathType, blockpos$mutableblockpos);
                }
            } else if (!this.isAmphibious() && pathtype == PathType.WATER && !this.canFloat()) {
                node = this.tryFindFirstNonWaterBelow(x, y, z, node);
            } else if (pathtype == PathType.OPEN) {
                node = this.tryFindFirstGroundNodeBelow(x, y, z);
            } else if (SmartNodeEvaluator.doesBlockHavePartialCollision(pathtype) && node == null) {
                node = this.getClosedNode(x, y, z, pathtype);
            }
            return node;
        }
        return node;
    }

    private Node getNodeAndUpdateCostToMax(int x, int y, int z, PathType pathType, float malus) {
        Node node = this.getNode(x, y, z);
        node.type = pathType;
        node.costMalus = Math.max(node.costMalus, malus);
        return node;
    }

    private Node getBlockedNode(int x, int y, int z) {
        Node node = this.getNode(x, y, z);
        node.type = PathType.BLOCKED;
        node.costMalus = -1.0f;
        return node;
    }

    private Node getClosedNode(int x, int y, int z, PathType pathType) {
        Node node = this.getNode(x, y, z);
        node.closed = true;
        node.type = pathType;
        node.costMalus = pathType.getMalus();
        return node;
    }

    @Nullable
    private Node tryJumpOn(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, Direction direction, PathType pathType, BlockPos.MutableBlockPos pos) {
        Node node = this.findAcceptedNode(x, y + 1, z, verticalDeltaLimit - 1, nodeFloorLevel, direction, pathType);
        if (node == null) {
            return null;
        }
        if (this.mob.getBbWidth() >= 1.0f) {
            return node;
        }
        if (node.type != PathType.OPEN && node.type != PathType.WALKABLE) {
            return node;
        }
        double d0 = (double)(x - direction.getStepX()) + 0.5;
        double d1 = (double)(z - direction.getStepZ()) + 0.5;
        double d2 = (double)this.mob.getBbWidth() / 2.0;
        AABB aabb = new AABB(d0 - d2, this.getFloorLevel((BlockPos)pos.set(d0, (double)(y + 1), d1)) + 0.001, d1 - d2, d0 + d2, (double)this.mob.getBbHeight() + this.getFloorLevel((BlockPos)pos.set((double)node.x, (double)node.y, (double)node.z)) - 0.002, d1 + d2);
        return this.hasCollisions(aabb) ? null : node;
    }

    @Nullable
    private Node tryFindFirstNonWaterBelow(int x, int y, int z, @Nullable Node node) {
        --y;
        while (y > this.mob.level().getMinBuildHeight()) {
            PathType pathtype = this.getCachedPathType(x, y, z);
            if (pathtype != PathType.WATER) {
                return node;
            }
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathtype, this.mob.getPathfindingMalus(pathtype));
            --y;
        }
        return node;
    }

    private Node tryFindFirstGroundNodeBelow(int x, int y, int z) {
        for (int i = y - 1; i >= this.mob.level().getMinBuildHeight(); --i) {
            if (y - i > this.mob.getMaxFallDistance()) {
                return this.getBlockedNode(x, i, z);
            }
            PathType pathtype = this.getCachedPathType(x, i, z);
            float f = this.mob.getPathfindingMalus(pathtype);
            if (pathtype == PathType.OPEN) continue;
            if (f >= 0.0f) {
                return this.getNodeAndUpdateCostToMax(x, i, z, pathtype, f);
            }
            return this.getBlockedNode(x, i, z);
        }
        return this.getBlockedNode(x, y, z);
    }

    private boolean hasCollisions(AABB boundingBox) {
        return this.collisionCache.computeIfAbsent((Object)boundingBox, p_330163_ -> !this.currentContext.level().noCollision((Entity)this.mob, boundingBox));
    }

    private double getMobJumpHeight() {
        Mob mob = this.mob;
        if (mob instanceof ISmartJump) {
            ISmartJump smartJump = (ISmartJump)mob;
            return Math.max((double)smartJump.getSuppportJump(), (double)this.mob.maxUpStep());
        }
        return Math.max(1.125, (double)this.mob.maxUpStep());
    }

    private static boolean doesBlockHavePartialCollision(PathType pathType) {
        return pathType == PathType.FENCE || pathType == PathType.DOOR_WOOD_CLOSED || pathType == PathType.DOOR_IRON_CLOSED;
    }

    private boolean canReachWithoutCollision(Node p_77625_) {
        AABB aabb = this.mob.getBoundingBox();
        Vec3 vec3 = new Vec3((double)p_77625_.x - this.mob.getX() + aabb.getXsize() / 2.0, (double)p_77625_.y - this.mob.getY() + aabb.getYsize() / 2.0, (double)p_77625_.z - this.mob.getZ() + aabb.getZsize() / 2.0);
        int i = Mth.ceil((double)(vec3.length() / aabb.getSize()));
        vec3 = vec3.scale((double)(1.0f / (float)i));
        for (int j = 1; j <= i; ++j) {
            if (!this.hasCollisions(aabb = aabb.move(vec3))) continue;
            return false;
        }
        return true;
    }
}

