/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.util;

import bagu_chan.bagus_lib.client.dialog.DialogType;
import bagu_chan.bagus_lib.message.DialogMessage;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

public class DialogHandler {
    public static final DialogHandler INSTANCE = new DialogHandler();
    public final Map<String, DialogType> dialogTypes = Maps.newHashMap();

    @OnlyIn(value=Dist.CLIENT)
    public void renderDialogue(GuiGraphics guiGraphics, float f, float tickCount) {
        DialogType dialogType;
        Minecraft minecraft = Minecraft.getInstance();
        float g = tickCount + f;
        PoseStack poseStack = guiGraphics.pose();
        int y = 14;
        for (Map.Entry<String, DialogType> dialogue : this.dialogTypes.entrySet()) {
            dialogType = dialogue.getValue();
            poseStack.pushPose();
            dialogType.render(guiGraphics, poseStack, f, tickCount, y);
            poseStack.popPose();
            poseStack.pushPose();
            dialogType.renderText(guiGraphics, poseStack, f, tickCount, y);
            poseStack.popPose();
            y += 20;
        }
        if (minecraft.level != null) {
            for (Map.Entry<String, DialogType> dialogue : this.dialogTypes.entrySet()) {
                dialogType = dialogue.getValue();
                if (dialogType.getDialogRenderTime() <= 0L || dialogType.getLastDialogRenderTime() >= minecraft.level.getGameTime()) continue;
                this.dialogTypes.remove(dialogue.getKey());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Deprecated
    public void addOrReplaceDialogType(String name, DialogType dialogType) {
        this.dialogTypes.remove(name);
        this.dialogTypes.put(name, dialogType);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void removeDialogType(String name) {
        this.dialogTypes.remove(name);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void removeAllDialogType() {
        this.dialogTypes.clear();
    }

    public static void addOrReplaceDialogTypeOnServer(ServerPlayer player, String name, DialogType dialogType) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, new DialogMessage(name, dialogType), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DrawString {
        private final double charsPerTick;
        private final String targetString;
        private final DrawFunction drawFunction;
        private double lastTick;
        private String subString = "";
        private final boolean ignoreWhiteSpace;

        public DrawString(double d, double e, String string, DrawFunction drawFunction, boolean ignoreWhiteSpace) {
            this.lastTick = d;
            this.charsPerTick = e;
            this.targetString = string;
            this.drawFunction = drawFunction;
            this.ignoreWhiteSpace = ignoreWhiteSpace;
        }

        public DrawString(double lastTick, double charsPerTick, String string, DrawFunction drawFunction) {
            this.lastTick = lastTick;
            this.charsPerTick = charsPerTick;
            this.targetString = string;
            this.drawFunction = drawFunction;
            this.ignoreWhiteSpace = true;
        }

        public boolean draw(double d, int i, int j) {
            int l;
            if (this.targetString.equals(this.subString)) {
                this.drawFunction.apply(this.targetString, i, j);
                return false;
            }
            int k = Mth.floor((double)((d - this.lastTick) * this.charsPerTick));
            if (k == 0) {
                this.drawFunction.apply(this.subString, i, j);
                return false;
            }
            if (this.ignoreWhiteSpace) {
                for (l = Math.min(this.subString.length() + k, this.targetString.length()); l >= 0 && l < this.targetString.length() && Character.isWhitespace(this.targetString.charAt(l - 1)); ++l) {
                }
            } else {
                l = Math.min(this.subString.length() + k, this.targetString.length());
            }
            if (l >= 0) {
                this.subString = this.targetString.substring(0, l);
                this.drawFunction.apply(this.subString, i, j);
            }
            this.lastTick = d;
            return true;
        }

        public double getLastTick() {
            return this.lastTick;
        }

        @OnlyIn(value=Dist.CLIENT)
        public static interface DrawFunction {
            public void apply(String var1, int var2, int var3);
        }
    }
}

