/*
 * Decompiled with CFR 0.152.
 */
package toni.redirected.utils.map;

import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.ticks.TickPriority;
import toni.redirected.utils.special.CommonValues;

public class CommonMaps {
    public static final Map<Integer, TickPriority> TICK_PRIORITY_VALUE_MAP = new Int2ObjectOpenHashMap();
    public static final Map<String, LootContext.EntityTarget> ENTITY_TARGET_NAME_MAP;
    public static final Map<String, JigsawBlockEntity.JointType> JOINT_TYPE_NAME_MAP;
    public static final Map<Integer, ChatFormatting> CHAT_FORMATTING_INDEX_MAP;
    public static final Map<Character, ChatFormatting> CHAT_FORMATTING_CODE_MAP;
    public static final List<String> CHAT_FORMATTING_LIST_WITH_IS_COLOR;
    public static final List<String> CHAT_FORMATTING_LIST_WITH_IS_FORMAT;
    public static final List<String> CHAT_FORMATTING_LIST_WITH_IS_FORMAT_OR_COLOR;
    public static final Map<String, BossEvent.BossBarColor> BOSS_BAR_COLOR_NAME_MAP;
    public static final Map<String, BossEvent.BossBarOverlay> BOSS_BAR_OVERLAY_NAME_MAP;
    public static final Map<String, EquipmentSlot> EQUIPMENT_SLOT_NAME_MAP;
    public static final Map<String, MushroomCow.MushroomType> MUSHROOM_TYPE_NAME_MAP;
    public static final Map<String, Boat.Type> BOAT_TYPE_NAME_MAP;

    static {
        for (TickPriority tickPriority : TickPriority.values()) {
            TICK_PRIORITY_VALUE_MAP.put(tickPriority.getValue(), tickPriority);
        }
        ENTITY_TARGET_NAME_MAP = new Object2ObjectOpenHashMap();
        ENTITY_TARGET_NAME_MAP.put("this", LootContext.EntityTarget.THIS);
        ENTITY_TARGET_NAME_MAP.put("attacker", LootContext.EntityTarget.ATTACKER);
        ENTITY_TARGET_NAME_MAP.put("direct_attacker", LootContext.EntityTarget.DIRECT_ATTACKER);
        ENTITY_TARGET_NAME_MAP.put("attacking_player", LootContext.EntityTarget.ATTACKING_PLAYER);
        JOINT_TYPE_NAME_MAP = new Object2ObjectOpenHashMap();
        JOINT_TYPE_NAME_MAP.put("rollable", JigsawBlockEntity.JointType.ROLLABLE);
        JOINT_TYPE_NAME_MAP.put("aligned", JigsawBlockEntity.JointType.ALIGNED);
        CHAT_FORMATTING_INDEX_MAP = new Int2ObjectOpenHashMap();
        CHAT_FORMATTING_CODE_MAP = new Char2ObjectOpenHashMap();
        CHAT_FORMATTING_LIST_WITH_IS_COLOR = new ObjectArrayList();
        CHAT_FORMATTING_LIST_WITH_IS_FORMAT = new ObjectArrayList();
        CHAT_FORMATTING_LIST_WITH_IS_FORMAT_OR_COLOR = new ObjectArrayList();
        for (TickPriority tickPriority : ChatFormatting.values()) {
            String name = tickPriority.getName();
            CHAT_FORMATTING_INDEX_MAP.put(tickPriority.getId(), (ChatFormatting)tickPriority);
            CHAT_FORMATTING_CODE_MAP.put(Character.valueOf(tickPriority.getChar()), (ChatFormatting)tickPriority);
            if (tickPriority.isColor()) {
                CHAT_FORMATTING_LIST_WITH_IS_COLOR.add(name);
            }
            if (tickPriority.isFormat()) {
                CHAT_FORMATTING_LIST_WITH_IS_FORMAT.add(name);
            }
            if (!tickPriority.isFormat() && !tickPriority.isColor()) continue;
            CHAT_FORMATTING_LIST_WITH_IS_FORMAT_OR_COLOR.add(name);
        }
        BOSS_BAR_COLOR_NAME_MAP = new Object2ObjectOpenHashMap();
        for (TickPriority tickPriority : BossEvent.BossBarColor.values()) {
            BOSS_BAR_COLOR_NAME_MAP.put(tickPriority.getName(), (BossEvent.BossBarColor)tickPriority);
        }
        BOSS_BAR_OVERLAY_NAME_MAP = new Object2ObjectOpenHashMap();
        for (TickPriority tickPriority : BossEvent.BossBarOverlay.values()) {
            BOSS_BAR_OVERLAY_NAME_MAP.put(tickPriority.getName(), (BossEvent.BossBarOverlay)tickPriority);
        }
        EQUIPMENT_SLOT_NAME_MAP = new Object2ObjectOpenHashMap();
        for (TickPriority tickPriority : toni.redirected.utils.values.CommonValues.EQUIPMENT_SLOTS) {
            EQUIPMENT_SLOT_NAME_MAP.put(tickPriority.getName(), (EquipmentSlot)tickPriority);
        }
        MUSHROOM_TYPE_NAME_MAP = new Object2ObjectOpenHashMap();
        MUSHROOM_TYPE_NAME_MAP.put("red", MushroomCow.MushroomType.RED);
        MUSHROOM_TYPE_NAME_MAP.put("brown", MushroomCow.MushroomType.BROWN);
        BOAT_TYPE_NAME_MAP = new Object2ObjectOpenHashMap();
        for (TickPriority tickPriority : CommonValues.BOAT_TYPES) {
            BOAT_TYPE_NAME_MAP.put(tickPriority.getName(), (Boat.Type)tickPriority);
        }
    }
}

