/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.SpriteCoordinateUnExpander;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.BookModelVisuals;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.BookType;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.PlaceableBookManager;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.PlaceableBookManagerClient;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.EnchantRedesignCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BookPileBlockTile
extends ItemDisplayTile
implements IExtraModelDataProvider {
    public final boolean horizontal;
    private float enchantPower = 0.0f;
    public final BooksList booksVisuals = new BooksList();
    public static final ModelDataKey<BooksList> BOOKS_KEY = ModBlockProperties.BOOKS_KEY;
    private static final RandomSource rand = RandomSource.create();

    public BookPileBlockTile(BlockPos pos, BlockState state) {
        this(pos, state, false);
    }

    public BookPileBlockTile(BlockPos pos, BlockState state, boolean horizontal) {
        super(ModRegistry.BOOK_PILE_TILE.get(), pos, state, 4);
        this.horizontal = horizontal;
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(BOOKS_KEY, (Object)this.booksVisuals);
    }

    private void displayRandomColoredBooks(int i, HolderLookup.Provider provider) {
        for (int j = 0; j < i; ++j) {
            int r = rand.nextInt(10);
            Item it = r < 2 ? Items.ENCHANTED_BOOK : (r < 3 ? Items.WRITABLE_BOOK : Items.BOOK);
            this.booksVisuals.add(new BookVisualData(it.getDefaultInstance(), this.worldPosition, j, this.horizontal, provider, null));
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (this.level != null && this.level.isClientSide) {
            this.requestModelReload();
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        NonNullList itemsCopy = null;
        if (componentInput.get(DataComponents.CONTAINER) == null) {
            itemsCopy = this.getItems();
            this.setItems(NonNullList.withSize((int)4, (Object)ItemStack.EMPTY));
        }
        super.applyImplicitComponents(componentInput);
        this.setItems(itemsCopy);
    }

    public void onItemRemoved(Player player, ItemStack stack, int slot) {
        super.onItemRemoved(player, stack, slot);
        int actualBookCount = (int)this.getItems().stream().filter(i -> !i.isEmpty()).count();
        if (actualBookCount == 0) {
            this.level.removeBlock(this.worldPosition, false);
        }
    }

    public void updateTileOnInventoryChanged() {
        super.updateTileOnInventoryChanged();
        int actualBookCount = (int)this.getItems().stream().filter(i -> !i.isEmpty()).count();
        if (actualBookCount != (Integer)this.getBlockState().getValue((Property)BookPileBlock.BOOKS)) {
            if (actualBookCount == 0) {
                return;
            }
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)BookPileBlock.BOOKS, (Comparable)Integer.valueOf(actualBookCount)), 2);
        }
        this.enchantPower = 0.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            Item item;
            BookType type;
            ItemStack itemStack = this.getItem(i2);
            if (itemStack.isEmpty() || (type = PlaceableBookManager.get(item = itemStack.getItem(), this.horizontal, (HolderLookup.Provider)this.level.registryAccess())) == null) continue;
            this.enchantPower += type.enchantPower();
        }
    }

    private void consolidateBookPile() {
        boolean prevEmpty = false;
        for (int i = 0; i < 4; ++i) {
            ItemStack it = this.getItem(i);
            if (it.isEmpty()) {
                prevEmpty = true;
                continue;
            }
            if (!prevEmpty) continue;
            this.getItems().set(i - 1, (Object)it);
            this.getItems().set(i, (Object)ItemStack.EMPTY);
        }
    }

    public void updateClientVisualsOnLoad() {
        ItemStack stack;
        this.booksVisuals.clear();
        for (int index = 0; index < 4 && !(stack = this.getItem(index)).isEmpty(); ++index) {
            BookModelVisuals last = index == 0 ? null : this.booksVisuals.get((int)(index - 1)).type;
            this.booksVisuals.add(index, new BookVisualData(stack, this.worldPosition, index, this.horizontal, (HolderLookup.Provider)this.level.registryAccess(), last));
        }
        if (this.booksVisuals.isEmpty()) {
            this.displayRandomColoredBooks((Integer)this.getBlockState().getValue((Property)BookPileBlock.BOOKS), (HolderLookup.Provider)this.level.registryAccess());
        }
    }

    public float getEnchantPower() {
        return this.enchantPower;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.supplementaries.book_pile");
    }

    public boolean canTakeItem(Container container, int i, ItemStack itemStack) {
        return false;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return false;
    }

    public boolean canOpen(Player player) {
        return false;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return null;
    }

    public record BooksList(List<BookVisualData> books) {
        public BooksList() {
            this(new ArrayList<BookVisualData>());
        }

        private void add(BookVisualData visualBook) {
            this.books.add(visualBook);
        }

        private void add(int i, BookVisualData visualBook) {
            this.books.add(i, visualBook);
        }

        private void clear() {
            this.books.clear();
        }

        public boolean isEmpty() {
            return this.books.isEmpty();
        }

        public BookVisualData get(int i) {
            return this.books.get(i);
        }

        public int size() {
            return this.books.size();
        }
    }

    public static class BookVisualData {
        private final float yAngle;
        private final BookModelVisuals type;
        private final ItemStack stack;

        public BookVisualData(ItemStack bookStack, BlockPos pos, int index, boolean isHorizontal, HolderLookup.Provider provider, @Nullable BookModelVisuals lastColor) {
            this.stack = bookStack;
            Random rand = new Random(pos.below(2).asLong());
            for (int j = 0; j < index; ++j) {
                rand.nextInt();
            }
            this.yAngle = (float)((double)rand.nextInt(32) * Math.PI / 16.0);
            List<BookModelVisuals> possibleTypes = PlaceableBookManagerClient.getValidModelsForBookItem(provider, this.stack, isHorizontal);
            List<Object> looksGood = new ArrayList();
            for (BookModelVisuals type : possibleTypes) {
                if (lastColor != null && !type.looksGoodNextTo(lastColor) || type == lastColor) continue;
                looksGood.add(type);
            }
            if (looksGood.isEmpty()) {
                looksGood = possibleTypes;
            }
            this.type = (BookModelVisuals)looksGood.get(rand.nextInt(looksGood.size()));
        }

        public VertexConsumer getBuilder(MultiBufferSource buffer) {
            if (this.type.hasGlint() && ClientConfigs.Tweaks.BOOK_GLINT.get().booleanValue()) {
                VertexConsumer foilBuilder = null;
                if (CompatHandler.ENCHANTEDBOOKREDESIGN) {
                    foilBuilder = EnchantRedesignCompat.getBookColoredFoil(this.stack, buffer);
                }
                if (foilBuilder == null) {
                    foilBuilder = new SpriteCoordinateUnExpander(buffer.getBuffer(RenderType.entityGlint()), ModMaterials.BOOK_GLINT_MATERIAL.sprite());
                }
                return foilBuilder;
            }
            return null;
        }

        public float getAngle() {
            return this.yAngle;
        }

        public ModelResourceLocation getModel() {
            return this.type.model();
        }
    }
}

