/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.TrappedPresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IFireItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.tiles.AbstractPresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.TrappedPresentContainerMenu;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TrappedPresentBlockTile
extends AbstractPresentBlockTile {
    public TrappedPresentBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.TRAPPED_PRESENT_TILE.get(), pos, state);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (this.level != null && !this.level.isClientSide) {
            boolean empty = this.getItem(0).isEmpty();
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)PresentBlock.PACKED, (Comparable)Boolean.valueOf(!empty)), 3);
        }
    }

    @Override
    public boolean canHoldItems() {
        return this.isPrimed();
    }

    public static boolean isPrimed(ItemStack stack) {
        CustomData beData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (beData != null) {
            CompoundTag tag = beData.getUnsafe().getCompound("BlockEntityTag");
            return tag.contains("Items");
        }
        return false;
    }

    public boolean isPrimed() {
        return (Boolean)this.getBlockState().getValue((Property)TrappedPresentBlock.PACKED);
    }

    public void updateState(boolean primed) {
        if (!this.level.isClientSide && this.isPrimed() != primed) {
            if (primed) {
                this.level.playSound(null, this.worldPosition, ModSounds.PRESENT_PACK.get(), SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.95f);
            } else {
                this.level.playSound(null, this.worldPosition, ModSounds.PRESENT_BREAK.get(), SoundSource.BLOCKS, 0.75f, this.level.random.nextFloat() * 0.1f + 1.2f);
            }
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)TrappedPresentBlock.PACKED, (Comparable)Boolean.valueOf(primed)), 3);
        }
    }

    public boolean canOpen(Player player) {
        if (!super.canOpen(player)) {
            return false;
        }
        if (!this.isUnused()) {
            return false;
        }
        return !this.isPrimed();
    }

    @Override
    public InteractionResult interact(Level level, BlockPos pos, BlockState state, Player player) {
        if (((Boolean)state.getValue((Property)TrappedPresentBlock.ON_COOLDOWN)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        if (this.isUnused()) {
            if (this.canOpen(player)) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PlatHelper.openCustomMenu((ServerPlayer)serverPlayer, (BlockEntity)this);
                    PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
                }
            } else {
                this.detonate((LevelAccessor)level, pos, state, player);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void detonate(LevelAccessor level, BlockPos pos, BlockState state, @Nullable Player opener) {
        level.setBlock(pos, (BlockState)state.setValue((Property)TrappedPresentBlock.ON_COOLDOWN, (Comparable)Boolean.valueOf(true)), 3);
        level.scheduleTick(pos, state.getBlock(), 10);
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            ItemStack stack = this.getItem(0);
            IFireItemBehavior behavior = TrappedPresentBlock.getPresentBehavior((ItemLike)stack.getItem());
            this.updateState(false);
            if (behavior.fire(stack.copyWithCount(1), sl, pos, 0.4f, new Vec3(0.0, 1.0, 0.0), 0.35f, 11, opener)) {
                stack.shrink(1);
            }
            sl.blockEvent(pos, this.getBlockState().getBlock(), 0, 0);
        }
    }

    public Component getDefaultName() {
        return Component.translatable((String)"gui.supplementaries.trapped_present");
    }

    public AbstractContainerMenu createMenu(int id, Inventory inv) {
        if (inv.player.isSpectator()) {
            return null;
        }
        return new TrappedPresentContainerMenu(id, inv, this);
    }

    public int getMaxStackSize() {
        return 1;
    }
}

