/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import java.util.EnumSet;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.entities.goals.ManeuverAndShootCannonBehavior;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.Nullable;

public class ManeuverAndShootCannonGoal
extends Goal {
    private final Mob mob;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    @Nullable
    private LivingEntity target;
    private int attackDelay;
    private int seeTime;
    private CannonAccess access;

    public ManeuverAndShootCannonGoal(Mob rangedAttackMob, int attackIntervalMin, int attackIntervalMax) {
        this.mob = rangedAttackMob;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        CannonAccess ac;
        Entity entity;
        LivingEntity livingEntity = this.mob.getTarget();
        if (livingEntity != null && livingEntity.isAlive() && (entity = this.mob.getControlledVehicle()) instanceof CannonAccess && (ac = (CannonAccess)entity).getInternalCannon().hasFuelAndProjectiles()) {
            this.access = ac;
            this.target = livingEntity;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse() || this.target.isAlive() && !this.mob.getNavigation().isDone();
    }

    public void stop() {
        this.target = null;
        this.access = null;
        this.seeTime = 0;
        this.attackDelay = 0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        boolean hasLineOfSight = this.mob.getSensing().hasLineOfSight((Entity)this.target);
        this.seeTime = hasLineOfSight ? ++this.seeTime : 0;
        this.mob.getLookControl().setLookAt((Entity)this.target, 90.0f, 90.0f);
        if (this.attackDelay > 0) {
            --this.attackDelay;
        }
        if (!hasLineOfSight) {
            return;
        }
        if (ManeuverAndShootCannonBehavior.aimCannonAndShoot(this.access, (LivingEntity)this.mob, this.target, this.attackDelay <= 0)) {
            this.attackDelay = Mth.randomBetweenInclusive((RandomSource)this.mob.getRandom(), (int)this.attackIntervalMin, (int)this.attackIntervalMax);
        }
    }
}

