/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SignPostBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SignPostWallBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StickBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FramedBlocksCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;

public class SignPostItem
extends WoodBasedBlockItem {
    public SignPostItem(Block block, Item.Properties properties, WoodType wood) {
        super(block, properties, wood);
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    private AttachType getAttachType(BlockState state) {
        Block b = state.getBlock();
        if (b instanceof SignPostWallBlock) {
            return AttachType.WAY_SIGN_WALL;
        }
        if (b instanceof SignPostBlock) {
            return AttachType.WAY_SIGN_POST;
        }
        if (b instanceof StickBlock && !((Boolean)state.getValue((Property)StickBlock.AXIS_X)).booleanValue() && !((Boolean)state.getValue((Property)StickBlock.AXIS_Z)).booleanValue() || state.getBlock() instanceof EndRodBlock && ((Direction)state.getValue((Property)EndRodBlock.FACING)).getAxis() == Direction.Axis.Y) {
            return AttachType.STICK;
        }
        ResourceLocation res = Utils.getID((Block)b);
        if (state.is(ModTags.POSTS) && !res.getNamespace().equals("blockcarpentry")) {
            return AttachType.FENCE;
        }
        return AttachType.WALL;
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        ItemStack itemstack = context.getItemInHand();
        BlockState state = level.getBlockState(blockpos);
        Block targetBlock = state.getBlock();
        boolean framed = false;
        AttachType attachType = this.getAttachType(state);
        int rotation = attachType.getRot(context);
        if (attachType.needsConversion()) {
            Block f;
            if (CompatHandler.FRAMEDBLOCKS && (f = FramedBlocksCompat.tryGettingFramedBlock(targetBlock, level, blockpos)) != null) {
                framed = true;
                if (f != Blocks.AIR) {
                    targetBlock = f;
                }
            }
            boolean waterlogged = level.getFluidState(blockpos).getType() == Fluids.WATER;
            level.setBlock(blockpos, (BlockState)ModRegistry.WAY_SIGN.get().getStateForPlacement(new BlockPlaceContext(context)).setValue((Property)SignPostBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), 3);
        } else if (attachType == AttachType.WALL) {
            BlockPlaceContext bpc = this.updatePlacementContext(new BlockPlaceContext(context));
            if (super.useOn(context).consumesAction()) {
                blockpos = bpc.getClickedPos();
                context = bpc;
            } else {
                return InteractionResult.PASS;
            }
        }
        BlockEntity blockEntity = level.getBlockEntity(blockpos);
        if (blockEntity instanceof SignPostBlockTile) {
            SignPostBlockTile tile = (SignPostBlockTile)blockEntity;
            double y = context.getClickLocation().y - (double)blockpos.getY();
            boolean up = y > 0.5;
            boolean addedSign = tile.trySetSign((WoodType)this.getBlockType(), rotation, up, framed);
            if (addedSign) {
                if (attachType != AttachType.WALL) {
                    if (attachType.needsConversion()) {
                        tile.setHeldBlock(targetBlock.defaultBlockState());
                    }
                    tile.setChanged();
                    level.sendBlockUpdated(blockpos, state, state, 3);
                    SoundType soundtype = ((WoodType)this.getBlockType()).getSound();
                    level.playSound(player, blockpos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                    level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, blockpos);
                    if (!context.getPlayer().isCreative()) {
                        itemstack.shrink(1);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        } else {
            Supplementaries.error();
        }
        return InteractionResult.PASS;
    }

    private static enum AttachType {
        FENCE,
        STICK,
        WALL,
        WAY_SIGN_POST,
        WAY_SIGN_WALL;


        int getRot(UseOnContext context) {
            return Mth.floor((double)((double)((180.0f + context.getRotation()) * 16.0f / 360.0f) + 0.5)) & 0xF;
        }

        public boolean needsConversion() {
            return this == FENCE || this == STICK;
        }

        public boolean isSign() {
            return this == WAY_SIGN_POST || this == WAY_SIGN_WALL;
        }
    }
}

