/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.entities.ISlimeable;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.common.utils.VibeChecker;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.EnvironmentalCompat;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SoapItem
extends Item {
    public static final FoodProperties SOAP_FOOD = new FoodProperties.Builder().nutrition(0).saturationModifier(0.1f).alwaysEdible().effect(new MobEffectInstance(MobEffects.POISON, 120, 2), 1.0f).build();

    public SoapItem(Item.Properties pProperties) {
        super(pProperties.food(SOAP_FOOD));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ISlimeable s;
        VibeChecker.assertSameLevel(level, player);
        ItemStack stack = player.getItemInHand(hand);
        if (player instanceof ISlimeable && (s = (ISlimeable)player).supp$getSlimedTicks() != 0) {
            s.supp$setSlimedTicks(0, true);
            SoapItem.playEffectsAndConsume(stack, player, (Entity)player);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        if (!SoapItem.hasBeenEatenBefore(player, level)) {
            if (player.canEat(true)) {
                player.startUsingItem(hand);
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
            }
            return InteractionResultHolder.fail((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity entity) {
        if (!pLevel.isClientSide) {
            NetworkHelper.sendToAllClientPlayersTrackingEntityAndSelf((Entity)entity, (Message)new ClientBoundParticlePacket((Entity)entity, ClientBoundParticlePacket.Kind.BUBBLE_EAT, entity.getViewVector(1.0f)));
        }
        return super.finishUsingItem(pStack, pLevel, entity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasBeenEatenBefore(Player player, Level level) {
        ResourceLocation res = Supplementaries.res("husbandry/soap");
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AdvancementHolder a = serverLevel.getServer().getAdvancements().get(res);
                if (a == null) return false;
                return serverPlayer.getAdvancements().getOrStartProgress(a).isDone();
            }
        }
        if (!(player instanceof LocalPlayer)) return false;
        LocalPlayer localPlayer = (LocalPlayer)player;
        ClientAdvancements advancements = localPlayer.connection.getAdvancements();
        AdvancementHolder a = advancements.get(res);
        if (a == null) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean interactWithEntity(ItemStack stack, Player player, Entity target, InteractionHand hand) {
        block8: {
            block11: {
                block10: {
                    block9: {
                        block7: {
                            level = player.level();
                            success = false;
                            if (!(target instanceof ISlimeable) || (s = (ISlimeable)target).supp$getSlimedTicks() == 0) break block7;
                            s.supp$setSlimedTicks(0, true);
                            success = true;
                            break block8;
                        }
                        if (!(target instanceof Sheep) || (s = (Sheep)target).getColor() == DyeColor.WHITE) break block9;
                        s.setColor(DyeColor.WHITE);
                        success = true;
                        break block8;
                    }
                    if (!(target instanceof WitherSkeleton)) break block10;
                    s = (WitherSkeleton)target;
                    wither = (Skeleton)s.convertTo(EntityType.SKELETON, true);
                    if (wither != null) {
                        wither.absRotateTo(target.getYRot(), target.getXRot());
                        target = wither;
                        success = true;
                    }
                    break block8;
                }
                if (!(target instanceof Slime)) break block11;
                s = (Slime)target;
                s.hurt(level.damageSources().playerAttack(player), 2.0f);
                success = true;
                break block8;
            }
            if (!(target instanceof Pig)) ** GOTO lbl-1000
            pig = (Pig)target;
            if (CompatHandler.ENVIRONMENTAL && EnvironmentalCompat.maybeCleanMuddyPig(pig)) {
                success = true;
            } else if (target instanceof TamableAnimal && (ta = (TamableAnimal)target).isOwnedBy((LivingEntity)player)) {
                if (target instanceof Wolf) {
                    wolf = (Wolf)target;
                    wolf.setCollarColor(DyeColor.RED);
                    wolf.isWet = true;
                }
                ta.setOrderedToSit(true);
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    p = target instanceof Cat != false ? ParticleTypes.ANGRY_VILLAGER : ParticleTypes.HEART;
                    serverLevel.sendParticles((ParticleOptions)p, target.getX(), target.getEyeY(), target.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                success = true;
            }
        }
        if (success) {
            SoapItem.playEffectsAndConsume(stack, player, target);
            return true;
        }
        return false;
    }

    private static void playEffectsAndConsume(ItemStack stack, Player player, Entity entity) {
        Level level = player.level();
        level.playSound(player, entity, ModSounds.SOAP_WASH.get(), SoundSource.PLAYERS, 1.0f, 0.9f + level.random.nextFloat() * 0.3f);
        if (!level.isClientSide) {
            NetworkHelper.sendToAllClientPlayersTrackingEntityAndSelf((Entity)entity, (Message)new ClientBoundParticlePacket(entity, ClientBoundParticlePacket.Kind.BUBBLE_CLEAN_ENTITY));
        }
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
    }
}

