/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.beautiful_potions.mixin;

import com.cerbon.beautiful_potions.BeautifulPotions;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ItemColors.class})
public abstract class ItemColorsMixin {
    @Redirect(method={"createDefault(Lnet/minecraft/client/color/block/BlockColors;)Lnet/minecraft/client/color/item/ItemColors;"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/color/item/ItemColors;register(Lnet/minecraft/client/color/item/ItemColor;[Lnet/minecraft/world/level/ItemLike;)V", ordinal=4))
    private static void removeColorFromPotions(ItemColors instance, ItemColor itemColor, ItemLike[] items) {
        instance.register((itemStack, i) -> {
            PotionContents potionContents = (PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            if (potionContents.potion().isEmpty()) {
                return -1;
            }
            Potion potion = (Potion)((Holder)potionContents.potion().get()).value();
            ResourceLocation potionRL = BuiltInRegistries.POTION.getKey((Object)potion);
            if (potionRL == null) {
                return -1;
            }
            String potionNamespace = potionRL.getNamespace();
            return i > 0 || BeautifulPotions.POTION_NAMESPACES.contains(potionNamespace) ? -1 : FastColor.ARGB32.opaque((int)potionContents.getColor());
        }, new ItemLike[]{Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION, Items.TIPPED_ARROW});
    }
}

