/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.particles.fluidparticle;

import com.direwolf20.buildinggadgets2.client.particles.fluidparticle.FluidFlowParticleData;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BreakingItemParticle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidFlowParticle
extends BreakingItemParticle {
    private double targetX;
    private double targetY;
    private double targetZ;
    Random random = new Random();
    private float partSize;
    private boolean doGravity;
    private boolean shrinking;
    private FluidStack fluidStack;
    public static ParticleProvider<FluidFlowParticleData> FACTORY = (data, world, x, y, z, xSpeed, ySpeed, zSpeed) -> new FluidFlowParticle(world, x, y, z, data.getFluidStack(), data.doGravity, data.shrinking);

    public FluidFlowParticle(ClientLevel world, double x, double y, double z, FluidStack fluidStack, boolean gravity, boolean shrinking) {
        super(world, x, y, z, ItemStack.EMPTY);
        this.fluidStack = fluidStack;
        this.doGravity = gravity;
        this.shrinking = shrinking;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        if (shrinking) {
            this.targetX = x + 1.75;
            this.targetY = y + 1.75;
            this.targetZ = z + 1.75;
        } else {
            double randomX = this.random.nextFloat();
            double randomY = this.random.nextFloat();
            double randomZ = this.random.nextFloat();
            this.xo = x + randomX;
            this.yo = y + randomY;
            this.zo = z + randomZ;
            this.setPos(this.xo, this.yo, this.zo);
            this.targetX = x;
            this.targetY = y;
            this.targetZ = z;
        }
        Vec3 target = new Vec3(this.targetX, this.targetY, this.targetZ);
        Vec3 source = new Vec3(this.x, this.y, this.z);
        Vec3 path = target.subtract(source).normalize().multiply(1.0, 1.0, 1.0);
        float minSize = 0.25f;
        float maxSize = 0.5f;
        this.partSize = minSize + this.random.nextFloat() * (maxSize - minSize);
        float speedModifier = 0.5f * (this.partSize - minSize) / (maxSize - minSize) + 0.25f;
        int ticksPerBlock = 15;
        float speedAdjust = (float)ticksPerBlock * (1.0f / speedModifier);
        this.xd += path.x / (double)speedAdjust;
        this.yd += path.y / (double)speedAdjust;
        this.zd += path.z / (double)speedAdjust;
        this.lifetime = 30;
        int longLifeChance = this.random.nextInt(20);
        if (longLifeChance == 0) {
            this.lifetime = 120;
        }
        this.scale(this.partSize);
        this.partSize = this.quadSize;
        this.setSprite((TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getStillTexture(fluidStack)));
        int i = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
        this.rCol *= (float)(i >> 16 & 0xFF) / 255.0f;
        this.gCol *= (float)(i >> 8 & 0xFF) / 255.0f;
        this.bCol *= (float)(i & 0xFF) / 255.0f;
        if (gravity) {
            this.xd = 0.0;
            this.yd = 0.0;
            this.zd = 0.0;
            this.gravity = 0.0625f;
            this.hasPhysics = true;
            this.age = this.lifetime / 2;
            this.scale(2.0f);
            this.partSize = this.quadSize;
            this.updateColorAndGravity();
        } else {
            this.gravity = 0.0f;
            this.hasPhysics = false;
        }
        if (!shrinking) {
            this.updateColorAndGravity();
        }
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd -= 0.04 * (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
        }
        if (!this.shrinking && this.y <= this.targetY) {
            this.remove();
        }
        this.updateColorAndGravity();
    }

    public void updateColorAndGravity() {
        float relativeAge = (float)(this.lifetime - this.age) / (float)this.lifetime;
        float shrink = Mth.lerp((float)relativeAge, (float)0.1f, (float)1.0f);
        this.quadSize = this.partSize * shrink;
        float adjustedAge = (float)Math.pow(relativeAge, 2.0);
        if (this.shrinking) {
            this.rCol = Mth.lerp((float)adjustedAge, (float)0.0f, (float)this.rCol);
            this.gCol = Mth.lerp((float)adjustedAge, (float)0.0f, (float)this.gCol);
            this.bCol = Mth.lerp((float)adjustedAge, (float)0.0f, (float)this.bCol);
        } else {
            int i = IClientFluidTypeExtensions.of((Fluid)this.fluidStack.getFluid()).getTintColor(this.fluidStack);
            float targetRed = (float)(i >> 16 & 0xFF) / 255.0f;
            float targetGreen = (float)(i >> 8 & 0xFF) / 255.0f;
            float targetBlue = (float)(i & 0xFF) / 255.0f;
            this.rCol = Mth.lerp((float)adjustedAge, (float)targetRed, (float)this.rCol);
            this.gCol = Mth.lerp((float)adjustedAge, (float)targetGreen, (float)this.gCol);
            this.bCol = Mth.lerp((float)adjustedAge, (float)targetBlue, (float)this.bCol);
        }
        if (relativeAge < 0.5f) {
            adjustedAge = (float)Math.pow(relativeAge / 0.5f, 2.0);
            this.alpha = this.shrinking ? Mth.lerp((float)adjustedAge, (float)0.4f, (float)1.0f) : Mth.lerp((float)adjustedAge, (float)1.0f, (float)0.2f);
        }
        if (!this.doGravity) {
            int gravityChance = this.random.nextInt(2);
            if (relativeAge < 0.75f && gravityChance == 0) {
                this.gravity = 0.05f;
            }
        }
    }

    protected int getLightColor(float pPartialTick) {
        return 0xF00080;
    }
}

