/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.mixin.core.main;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.config.ATLProperties;
import dev.uncandango.alltheleaks.feature.common.mods.minecraft.IngredientDedupe;
import dev.uncandango.alltheleaks.mixin.Lockable;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;

@Mixin(value={Ingredient.class})
public class IngredientMixin {
    @WrapMethod(method={"fromValues"})
    private static Ingredient grabIngredient(Stream<? extends Ingredient.Value> stream, Operation<Ingredient> original) {
        Ingredient ingredient;
        Ingredient dedupedIngredient;
        Ingredient origIngredient = (Ingredient)original.call(new Object[]{stream});
        if (!origIngredient.isEmpty() && !origIngredient.isCustom() && (dedupedIngredient = IngredientDedupe.intern(origIngredient)) != origIngredient && (ingredient = dedupedIngredient) instanceof IngredientAccessor) {
            IngredientAccessor accessor = (IngredientAccessor)ingredient;
            if (ATLProperties.get().debugItemStackModifications) {
                Ingredient.Value[] values = origIngredient.getValues();
                if (values.length > 0 && values[0] instanceof Ingredient.ItemValue) {
                    ItemStack[] dedupeStacks;
                    ItemStack[] origStacks = origIngredient.getItems();
                    if (origStacks.length != (dedupeStacks = dedupedIngredient.getItems()).length) {
                        AllTheLeaks.LOGGER.error("Ingredient stack length is not the same");
                    } else {
                        for (int i = 0; i < origStacks.length; ++i) {
                            ItemStack origStack = origStacks[i];
                            ItemStack dedupeStack = dedupeStacks[i];
                            if (ItemStack.isSameItemSameComponents((ItemStack)origStack, (ItemStack)dedupeStack)) continue;
                            IllegalArgumentException error = new IllegalArgumentException("Itemstack is not equal as deduped one");
                            AllTheLeaks.LOGGER.error("Error checking stack integrity", (Throwable)error);
                        }
                    }
                }
                if (!((Lockable)dedupedIngredient).atl$isLocked()) {
                    ((Lockable)dedupedIngredient).atl$setLocked(true);
                }
            }
            return dedupedIngredient;
        }
        return origIngredient;
    }

    @Mixin(value={Ingredient.class})
    public static interface IngredientAccessor {
        @Accessor(value="itemStacks")
        public void setItemStacks(ItemStack[] var1);
    }
}

