/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.miscellaneous;

import guideme.internal.shaded.lucene.analysis.TokenFilterFactory;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.miscellaneous.FingerprintFilter;
import java.util.Map;

public class FingerprintFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "fingerprint";
    public static final String MAX_OUTPUT_TOKEN_SIZE_KEY = "maxOutputTokenSize";
    public static final String SEPARATOR_KEY = "separator";
    final int maxOutputTokenSize;
    final char separator;

    public FingerprintFilterFactory(Map<String, String> args) {
        super(args);
        this.maxOutputTokenSize = this.getInt(args, MAX_OUTPUT_TOKEN_SIZE_KEY, 1024);
        this.separator = this.getChar(args, SEPARATOR_KEY, ' ');
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public FingerprintFilterFactory() {
        throw FingerprintFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new FingerprintFilter(input, this.maxOutputTokenSize, this.separator);
    }
}

