/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.FilteredTermsEnum;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefBuilder;
import guideme.internal.shaded.lucene.util.IntsRefBuilder;
import guideme.internal.shaded.lucene.util.StringHelper;
import guideme.internal.shaded.lucene.util.automaton.ByteRunnable;
import guideme.internal.shaded.lucene.util.automaton.CompiledAutomaton;
import guideme.internal.shaded.lucene.util.automaton.Transition;
import guideme.internal.shaded.lucene.util.automaton.TransitionAccessor;
import java.io.IOException;
import java.util.Arrays;

public class AutomatonTermsEnum
extends FilteredTermsEnum {
    private final ByteRunnable byteRunnable;
    private final BytesRef commonSuffixRef;
    private final boolean finite;
    private final TransitionAccessor transitionAccessor;
    private short[] visited;
    private short curGen;
    private final BytesRefBuilder seekBytesRef = new BytesRefBuilder();
    private boolean linear;
    private final BytesRef linearUpperBound = new BytesRef();
    private final Transition transition = new Transition();
    private final IntsRefBuilder savedStates = new IntsRefBuilder();

    public AutomatonTermsEnum(TermsEnum tenum, CompiledAutomaton compiled) {
        super(tenum);
        if (compiled.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) {
            throw new IllegalArgumentException("please use CompiledAutomaton.getTermsEnum instead");
        }
        this.finite = compiled.finite;
        this.byteRunnable = compiled.getByteRunnable();
        this.transitionAccessor = compiled.getTransitionAccessor();
        this.commonSuffixRef = compiled.commonSuffixRef;
        this.visited = this.finite ? null : new short[this.byteRunnable.getSize()];
    }

    private void setVisited(int state) {
        if (!this.finite) {
            if (state >= this.visited.length) {
                this.visited = ArrayUtil.grow(this.visited, state + 1);
            }
            this.visited[state] = this.curGen;
        }
    }

    private boolean isVisited(int state) {
        return !this.finite && state < this.visited.length && this.visited[state] == this.curGen;
    }

    @Override
    protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
        if (this.commonSuffixRef == null || StringHelper.endsWith(term, this.commonSuffixRef)) {
            if (this.byteRunnable.run(term.bytes, term.offset, term.length)) {
                return this.linear ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.YES_AND_SEEK;
            }
            return this.linear && term.compareTo(this.linearUpperBound) < 0 ? FilteredTermsEnum.AcceptStatus.NO : FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
        }
        return this.linear && term.compareTo(this.linearUpperBound) < 0 ? FilteredTermsEnum.AcceptStatus.NO : FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
    }

    @Override
    protected BytesRef nextSeekTerm(BytesRef term) throws IOException {
        if (term == null) {
            assert (this.seekBytesRef.length() == 0);
            if (this.byteRunnable.isAccept(0)) {
                return this.seekBytesRef.get();
            }
        } else {
            this.seekBytesRef.copyBytes(term);
        }
        if (this.nextString()) {
            return this.seekBytesRef.get();
        }
        return null;
    }

    private void setLinear(int position) {
        int length;
        assert (!this.linear);
        int state = 0;
        int maxInterval = 255;
        for (int i = 0; i < position; ++i) {
            state = this.byteRunnable.step(state, this.seekBytesRef.byteAt(i) & 0xFF);
            assert (state >= 0) : "state=" + state;
        }
        int numTransitions = this.transitionAccessor.getNumTransitions(state);
        this.transitionAccessor.initTransition(state, this.transition);
        for (int i = 0; i < numTransitions; ++i) {
            this.transitionAccessor.getNextTransition(this.transition);
            if (this.transition.min > (this.seekBytesRef.byteAt(position) & 0xFF) || (this.seekBytesRef.byteAt(position) & 0xFF) > this.transition.max) continue;
            maxInterval = this.transition.max;
            break;
        }
        if (maxInterval != 255) {
            ++maxInterval;
        }
        if (this.linearUpperBound.bytes.length < (length = position + 1)) {
            this.linearUpperBound.bytes = new byte[ArrayUtil.oversize(length, 1)];
        }
        System.arraycopy(this.seekBytesRef.bytes(), 0, this.linearUpperBound.bytes, 0, position);
        this.linearUpperBound.bytes[position] = (byte)maxInterval;
        this.linearUpperBound.length = length;
        this.linear = true;
    }

    private boolean nextString() {
        int pos = 0;
        this.savedStates.grow(this.seekBytesRef.length() + 1);
        this.savedStates.setIntAt(0, 0);
        while (true) {
            if (!this.finite && (this.curGen = (short)(this.curGen + 1)) == 0) {
                Arrays.fill(this.visited, (short)-1);
            }
            this.linear = false;
            int state = this.savedStates.intAt(pos);
            while (pos < this.seekBytesRef.length()) {
                this.setVisited(state);
                int nextState = this.byteRunnable.step(state, this.seekBytesRef.byteAt(pos) & 0xFF);
                if (nextState == -1) break;
                this.savedStates.setIntAt(pos + 1, nextState);
                if (!this.linear && this.isVisited(nextState)) {
                    this.setLinear(pos);
                }
                state = nextState;
                ++pos;
            }
            if (this.nextString(state, pos)) {
                return true;
            }
            if ((pos = this.backtrack(pos)) < 0) {
                return false;
            }
            int newState = this.byteRunnable.step(this.savedStates.intAt(pos), this.seekBytesRef.byteAt(pos) & 0xFF);
            if (newState >= 0 && this.byteRunnable.isAccept(newState)) {
                return true;
            }
            if (this.finite) continue;
            pos = 0;
        }
    }

    private boolean nextString(int state, int position) {
        int c = 0;
        if (position < this.seekBytesRef.length()) {
            c = this.seekBytesRef.byteAt(position) & 0xFF;
            if (c++ == 255) {
                return false;
            }
        }
        this.seekBytesRef.setLength(position);
        this.setVisited(state);
        int numTransitions = this.transitionAccessor.getNumTransitions(state);
        this.transitionAccessor.initTransition(state, this.transition);
        for (int i = 0; i < numTransitions; ++i) {
            this.transitionAccessor.getNextTransition(this.transition);
            if (this.transition.max < c) continue;
            int nextChar = Math.max(c, this.transition.min);
            this.seekBytesRef.append((byte)nextChar);
            state = this.transition.dest;
            while (!this.isVisited(state) && !this.byteRunnable.isAccept(state)) {
                this.setVisited(state);
                this.transitionAccessor.initTransition(state, this.transition);
                this.transitionAccessor.getNextTransition(this.transition);
                state = this.transition.dest;
                this.seekBytesRef.append((byte)this.transition.min);
                if (this.linear || !this.isVisited(state)) continue;
                this.setLinear(this.seekBytesRef.length() - 1);
            }
            return true;
        }
        return false;
    }

    private int backtrack(int position) {
        while (position-- > 0) {
            int nextChar = this.seekBytesRef.byteAt(position) & 0xFF;
            if (nextChar++ == 255) continue;
            this.seekBytesRef.setByteAt(position, (byte)nextChar);
            this.seekBytesRef.setLength(position + 1);
            return position;
        }
        return -1;
    }
}

