/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.codecs.Codec;
import guideme.internal.shaded.lucene.codecs.NormsProducer;
import guideme.internal.shaded.lucene.codecs.TermVectorsFormat;
import guideme.internal.shaded.lucene.codecs.TermVectorsReader;
import guideme.internal.shaded.lucene.codecs.TermVectorsWriter;
import guideme.internal.shaded.lucene.codecs.lucene90.compressing.Lucene90CompressingTermVectorsFormat;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.FieldInfos;
import guideme.internal.shaded.lucene.index.Fields;
import guideme.internal.shaded.lucene.index.PostingsEnum;
import guideme.internal.shaded.lucene.index.SegmentInfo;
import guideme.internal.shaded.lucene.index.SegmentWriteState;
import guideme.internal.shaded.lucene.index.Sorter;
import guideme.internal.shaded.lucene.index.SortingStoredFieldsConsumer;
import guideme.internal.shaded.lucene.index.TermVectorsConsumer;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.index.TermsHashPerField;
import guideme.internal.shaded.lucene.index.TrackingTmpOutputDirectoryWrapper;
import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.FlushInfo;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.util.ByteBlockPool;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.IOUtils;
import guideme.internal.shaded.lucene.util.IntBlockPool;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

final class SortingTermVectorsConsumer
extends TermVectorsConsumer {
    private static final TermVectorsFormat TEMP_TERM_VECTORS_FORMAT = new Lucene90CompressingTermVectorsFormat("TempTermVectors", "", SortingStoredFieldsConsumer.NO_COMPRESSION, 8192, 128, 10);
    TrackingTmpOutputDirectoryWrapper tmpDirectory;

    SortingTermVectorsConsumer(IntBlockPool.Allocator intBlockAllocator, ByteBlockPool.Allocator byteBlockAllocator, Directory directory, SegmentInfo info, Codec codec) {
        super(intBlockAllocator, byteBlockAllocator, directory, info, codec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void flush(Map<String, TermsHashPerField> fieldsToFlush, SegmentWriteState state, Sorter.DocMap sortMap, NormsProducer norms) throws IOException {
        super.flush(fieldsToFlush, state, sortMap, norms);
        if (this.tmpDirectory != null) {
            TermVectorsReader reader = TEMP_TERM_VECTORS_FORMAT.vectorsReader(this.tmpDirectory, state.segmentInfo, state.fieldInfos, IOContext.DEFAULT);
            TermVectorsWriter writer = this.codec.termVectorsFormat().vectorsWriter(state.directory, state.segmentInfo, state.context);
            try {
                reader.checkIntegrity();
                for (int docID = 0; docID < state.segmentInfo.maxDoc(); ++docID) {
                    Fields vectors = reader.get(sortMap == null ? docID : sortMap.newToOld(docID));
                    SortingTermVectorsConsumer.writeTermVectors(writer, vectors, state.fieldInfos);
                }
                writer.finish(state.segmentInfo.maxDoc());
            }
            catch (Throwable throwable) {
                IOUtils.close(reader, writer);
                IOUtils.deleteFiles(this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
                throw throwable;
            }
            IOUtils.close(reader, writer);
            IOUtils.deleteFiles(this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
        }
    }

    @Override
    void initTermVectorsWriter() throws IOException {
        if (this.writer == null) {
            IOContext context = new IOContext(new FlushInfo(this.lastDocID, this.bytesUsed.get()));
            this.tmpDirectory = new TrackingTmpOutputDirectoryWrapper(this.directory);
            this.writer = TEMP_TERM_VECTORS_FORMAT.vectorsWriter(this.tmpDirectory, this.info, context);
            this.lastDocID = 0;
        }
    }

    @Override
    public void abort() {
        try {
            super.abort();
        }
        finally {
            if (this.tmpDirectory != null) {
                IOUtils.deleteFilesIgnoringExceptions((Directory)this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
            }
        }
    }

    private static void writeTermVectors(TermVectorsWriter writer, Fields vectors, FieldInfos fieldInfos) throws IOException {
        if (vectors == null) {
            writer.startDocument(0);
            writer.finishDocument();
            return;
        }
        int numFields = vectors.size();
        if (numFields == -1) {
            numFields = 0;
            Iterator<String> it = vectors.iterator();
            while (it.hasNext()) {
                it.next();
                ++numFields;
            }
        }
        writer.startDocument(numFields);
        String lastFieldName = null;
        TermsEnum termsEnum = null;
        PostingsEnum docsAndPositionsEnum = null;
        int fieldCount = 0;
        for (String fieldName : vectors) {
            ++fieldCount;
            FieldInfo fieldInfo = fieldInfos.fieldInfo(fieldName);
            assert (lastFieldName == null || fieldName.compareTo(lastFieldName) > 0) : "lastFieldName=" + lastFieldName + " fieldName=" + fieldName;
            lastFieldName = fieldName;
            Terms terms = vectors.terms(fieldName);
            if (terms == null) continue;
            boolean hasPositions = terms.hasPositions();
            boolean hasOffsets = terms.hasOffsets();
            boolean hasPayloads = terms.hasPayloads();
            assert (!hasPayloads || hasPositions);
            int numTerms = (int)terms.size();
            if (numTerms == -1) {
                numTerms = 0;
                termsEnum = terms.iterator();
                while (termsEnum.next() != null) {
                    ++numTerms;
                }
            }
            writer.startField(fieldInfo, numTerms, hasPositions, hasOffsets, hasPayloads);
            termsEnum = terms.iterator();
            int termCount = 0;
            while (termsEnum.next() != null) {
                ++termCount;
                int freq = (int)termsEnum.totalTermFreq();
                writer.startTerm(termsEnum.term(), freq);
                if (hasPositions || hasOffsets) {
                    docsAndPositionsEnum = termsEnum.postings(docsAndPositionsEnum, 120);
                    assert (docsAndPositionsEnum != null);
                    int docID = docsAndPositionsEnum.nextDoc();
                    assert (docID != Integer.MAX_VALUE);
                    assert (docsAndPositionsEnum.freq() == freq);
                    for (int posUpto = 0; posUpto < freq; ++posUpto) {
                        int pos = docsAndPositionsEnum.nextPosition();
                        int startOffset = docsAndPositionsEnum.startOffset();
                        int endOffset = docsAndPositionsEnum.endOffset();
                        BytesRef payload = docsAndPositionsEnum.getPayload();
                        assert (!hasPositions || pos >= 0);
                        writer.addPosition(pos, startOffset, endOffset, payload);
                    }
                }
                writer.finishTerm();
            }
            assert (termCount == numTerms);
            writer.finishField();
        }
        assert (fieldCount == numFields);
        writer.finishDocument();
    }
}

