/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.Lock;
import guideme.internal.shaded.lucene.store.LockFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class VerifyingLockFactory
extends LockFactory {
    public static final int MSG_LOCK_RELEASED = 0;
    public static final int MSG_LOCK_ACQUIRED = 1;
    final LockFactory lf;
    final InputStream in;
    final OutputStream out;

    public VerifyingLockFactory(LockFactory lf, InputStream in, OutputStream out) throws IOException {
        this.lf = lf;
        this.in = in;
        this.out = out;
    }

    @Override
    public Lock obtainLock(Directory dir, String lockName) throws IOException {
        return new CheckedLock(this.lf.obtainLock(dir, lockName));
    }

    private class CheckedLock
    extends Lock {
        private final Lock lock;

        public CheckedLock(Lock lock) throws IOException {
            this.lock = lock;
            this.verify((byte)1);
        }

        @Override
        public void ensureValid() throws IOException {
            this.lock.ensureValid();
        }

        @Override
        public void close() throws IOException {
            try (Lock l = this.lock;){
                l.ensureValid();
                this.verify((byte)0);
            }
        }

        private void verify(byte message) throws IOException {
            VerifyingLockFactory.this.out.write(message);
            VerifyingLockFactory.this.out.flush();
            int ret = VerifyingLockFactory.this.in.read();
            if (ret < 0) {
                throw new IllegalStateException("Lock server died because of locking error.");
            }
            if (ret != message) {
                throw new IOException("Protocol violation.");
            }
        }
    }
}

