/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util;

public class SmallFloat {
    private static final int MAX_INT4 = SmallFloat.longToInt4(Integer.MAX_VALUE);
    private static final int NUM_FREE_VALUES = 255 - MAX_INT4;

    private SmallFloat() {
    }

    public static byte floatToByte(float f, int numMantissaBits, int zeroExp) {
        int fzero = 63 - zeroExp << numMantissaBits;
        int bits = Float.floatToRawIntBits(f);
        int smallfloat = bits >> 24 - numMantissaBits;
        if (smallfloat <= fzero) {
            return bits <= 0 ? (byte)0 : 1;
        }
        if (smallfloat >= fzero + 256) {
            return -1;
        }
        return (byte)(smallfloat - fzero);
    }

    public static float byteToFloat(byte b, int numMantissaBits, int zeroExp) {
        if (b == 0) {
            return 0.0f;
        }
        int bits = (b & 0xFF) << 24 - numMantissaBits;
        return Float.intBitsToFloat(bits += 63 - zeroExp << 24);
    }

    public static byte floatToByte315(float f) {
        int bits = Float.floatToRawIntBits(f);
        int smallfloat = bits >> 21;
        if (smallfloat <= 384) {
            return bits <= 0 ? (byte)0 : 1;
        }
        if (smallfloat >= 640) {
            return -1;
        }
        return (byte)(smallfloat - 384);
    }

    public static float byte315ToFloat(byte b) {
        if (b == 0) {
            return 0.0f;
        }
        int bits = (b & 0xFF) << 21;
        return Float.intBitsToFloat(bits += 0x30000000);
    }

    public static int longToInt4(long i) {
        if (i < 0L) {
            throw new IllegalArgumentException("Only supports positive values, got " + i);
        }
        int numBits = 64 - Long.numberOfLeadingZeros(i);
        if (numBits < 4) {
            return Math.toIntExact(i);
        }
        int shift = numBits - 4;
        int encoded = Math.toIntExact(i >>> shift);
        encoded &= 7;
        return encoded |= shift + 1 << 3;
    }

    public static final long int4ToLong(int i) {
        long bits = i & 7;
        int shift = (i >>> 3) - 1;
        long decoded = shift == -1 ? bits : (bits | 8L) << shift;
        return decoded;
    }

    public static byte intToByte4(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Only supports positive values, got " + i);
        }
        if (i < NUM_FREE_VALUES) {
            return (byte)i;
        }
        return (byte)(NUM_FREE_VALUES + SmallFloat.longToInt4(i - NUM_FREE_VALUES));
    }

    public static int byte4ToInt(byte b) {
        int i = Byte.toUnsignedInt(b);
        if (i < NUM_FREE_VALUES) {
            return i;
        }
        long decoded = (long)NUM_FREE_VALUES + SmallFloat.int4ToLong(i - NUM_FREE_VALUES);
        return Math.toIntExact(decoded);
    }
}

