/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.feature;

import dev.worldgen.lithostitched.worldgen.feature.config.VinesConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class VinesFeature
extends Feature<VinesConfig> {
    public static final VinesFeature FEATURE = new VinesFeature();

    public VinesFeature() {
        super(VinesConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<VinesConfig> context) {
        VinesConfig config = (VinesConfig)context.config();
        WorldGenLevel level = context.level();
        BlockPos.MutableBlockPos pos = context.origin().mutable();
        Optional states = config.blocks().getRandomValue(context.random());
        if (states.isEmpty()) {
            return false;
        }
        boolean anyPlaced = false;
        for (int i = 0; i < config.maxLength().sample(context.random()) && level.isEmptyBlock((BlockPos)pos); ++i) {
            Block vine = (Block)states.get();
            boolean placed = false;
            for (Direction direction : Direction.values()) {
                BlockState aboveState;
                if (direction == Direction.DOWN) continue;
                if (VineBlock.isAcceptableNeighbour((BlockGetter)level, (BlockPos)pos.relative(direction), (Direction)direction) && config.canPlaceOn(level.getBlockState(pos.relative(direction)))) {
                    level.setBlock((BlockPos)pos, (BlockState)vine.defaultBlockState().setValue((Property)VineBlock.getPropertyForFace((Direction)direction), (Comparable)Boolean.valueOf(true)), 2);
                    placed = true;
                }
                if (!((aboveState = level.getBlockState(pos.above())).getBlock() instanceof VineBlock) || !((Boolean)aboveState.getValue((Property)VineBlock.NORTH)).booleanValue() && !((Boolean)aboveState.getValue((Property)VineBlock.EAST)).booleanValue() && !((Boolean)aboveState.getValue((Property)VineBlock.SOUTH)).booleanValue() && !((Boolean)aboveState.getValue((Property)VineBlock.WEST)).booleanValue()) continue;
                level.setBlock((BlockPos)pos, (BlockState)vine.withPropertiesOf(aboveState).setValue((Property)VineBlock.UP, (Comparable)Boolean.valueOf(false)), 2);
                placed = true;
            }
            if (!placed) break;
            anyPlaced = true;
            pos.move(Direction.DOWN);
        }
        return anyPlaced;
    }
}

