/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.poolalias;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;

public record RandomEntries(List<ResourceKey<StructureTemplatePool>> aliases, List<HolderSet<StructureTemplatePool>> pools) implements PoolAliasBinding
{
    public static final MapCodec<RandomEntries> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.TEMPLATE_POOL).listOf().fieldOf("aliases").forGetter(RandomEntries::aliases), (App)HolderSetCodec.create((ResourceKey)Registries.TEMPLATE_POOL, (Codec)StructureTemplatePool.CODEC, (boolean)false).listOf().fieldOf("pools").forGetter(RandomEntries::pools)).apply((Applicative)instance, RandomEntries::new)).validate(RandomEntries::validate);

    private static DataResult<RandomEntries> validate(RandomEntries entry) {
        if (entry.pools.size() == entry.aliases.size()) {
            Integer size = null;
            for (HolderSet<StructureTemplatePool> pool : entry.pools) {
                if (size != null && pool.size() != size.intValue()) {
                    return DataResult.error(() -> "Each template pool set should have the same number of entries");
                }
                size = pool.size();
            }
            return DataResult.success((Object)entry);
        }
        return DataResult.error(() -> "List of aliases and list of pools should be the same length");
    }

    public void forEachResolved(RandomSource random, BiConsumer<ResourceKey<StructureTemplatePool>, ResourceKey<StructureTemplatePool>> consumer) {
        int index = random.nextInt(this.pools.getFirst().size());
        for (int i = 0; i < this.pools.size(); ++i) {
            consumer.accept(this.aliases.get(i), (ResourceKey<StructureTemplatePool>)((ResourceKey)this.pools.get(i).get(index).unwrapKey().get()));
        }
    }

    public Stream<ResourceKey<StructureTemplatePool>> allTargets() {
        return Stream.of(new ResourceKey[0]);
    }

    public MapCodec<? extends PoolAliasBinding> codec() {
        return CODEC;
    }
}

