/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.mehvahdjukaar.amendments.common.tile.CarpetedBlockTile;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.block.IRecolorable;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CarpetSlabBlock
extends SlabBlock
implements EntityBlock,
IRecolorable {
    public static final MapCodec<CarpetSlabBlock> CODEC = CarpetSlabBlock.simpleCodec(CarpetSlabBlock::new);
    public static final IntegerProperty LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL;
    public static final BooleanProperty SOLID = ModBlockProperties.SOLID;
    protected static final VoxelShape BOTTOM_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);

    public CarpetSlabBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(state -> (Integer)state.getValue((Property)LIGHT_LEVEL)));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)SOLID, (Comparable)Boolean.valueOf(true))).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<? extends CarpetSlabBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BOTTOM_AABB;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)SOLID) != false ? super.getOcclusionShape(state, level, pos) : Shapes.empty();
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        IBlockHolder tile;
        BlockState mimicState;
        super.spawnDestroyParticles(level, player, pos, state);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IBlockHolder && !(mimicState = (tile = (IBlockHolder)blockEntity).getHeldBlock(1)).isAir()) {
            SoundType sound = mimicState.getSoundType();
            level.playSound(null, pos, sound.getBreakSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, this.soundType.getPitch() * 0.8f);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIGHT_LEVEL, SOLID});
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        IBlockHolder tile;
        BlockState mimicState;
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof IBlockHolder && !(mimicState = (tile = (IBlockHolder)blockEntity).getHeldBlock()).isAir() && !(mimicState.getBlock() instanceof CarpetSlabBlock)) {
            return mimicState.getDestroyProgress(player, worldIn, pos);
        }
        return super.getDestroyProgress(state, player, worldIn, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        CarpetedBlockTile tile;
        SoundType mixed;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CarpetedBlockTile && (mixed = (tile = (CarpetedBlockTile)blockEntity).getSoundType()) != null) {
            return mixed;
        }
        return super.getSoundType(state);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof IBlockHolder) {
            IBlockHolder tile = (IBlockHolder)object;
            BlockState heldState = tile.getHeldBlock(0);
            BlockState carpet = tile.getHeldBlock(1);
            Object object2 = builder.getOptionalParameter(LootContextParams.THIS_ENTITY);
            if (object2 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)object2;
                if (ForgeHelper.canHarvestBlock((BlockState)heldState, (ServerLevel)builder.getLevel(), (BlockPos)BlockPos.containing((Position)((Position)builder.getParameter(LootContextParams.ORIGIN))), (ServerPlayer)player)) {
                    drops.addAll(heldState.getDrops(builder));
                }
            }
            drops.addAll(carpet.getDrops(builder));
        }
        return drops;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CarpetedBlockTile) {
            BlockHitResult hs;
            CarpetedBlockTile tile = (CarpetedBlockTile)blockEntity;
            if (target instanceof BlockHitResult && (hs = (BlockHitResult)target).getDirection() == Direction.UP) {
                return tile.getHeldBlock(1).getBlock().getCloneItemStack(level, pos, state);
            }
            BlockState mimic = tile.getHeldBlock();
            return mimic.getBlock().getCloneItemStack(level, pos, state);
        }
        return super.getCloneItemStack(level, pos, state);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CarpetedBlockTile) {
            CarpetedBlockTile tile = (CarpetedBlockTile)blockEntity;
            BlockState mimic = tile.getHeldBlock();
            return mimic.getBlock().getCloneItemStack(level, pos, state);
        }
        return super.getCloneItemStack(level, pos, state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new CarpetedBlockTile(pPos, pState);
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && fluidState.getType() == Fluids.WATER) {
            BlockEntity blockEntity;
            if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof CarpetedBlockTile) {
                CarpetedBlockTile te = (CarpetedBlockTile)blockEntity;
                if (level instanceof Level) {
                    Level l = (Level)level;
                    Block.popResource((Level)l, (BlockPos)pos, (ItemStack)te.getCarpet().getBlock().asItem().getDefaultInstance());
                    level.setBlock(pos, (BlockState)te.getHeldBlock().getBlock().withPropertiesOf(state).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                    level.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
                }
            }
            return true;
        }
        return false;
    }

    public boolean tryRecolor(Level level, BlockPos blockPos, BlockState blockState, @Nullable DyeColor dyeColor) {
        Block otherCarpet;
        CarpetedBlockTile tile;
        BlockState c;
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof CarpetedBlockTile && !(c = (tile = (CarpetedBlockTile)blockEntity).getHeldBlock()).isAir() && (otherCarpet = BlocksColorAPI.changeColor((Block)c.getBlock(), (DyeColor)dyeColor)) != null && !c.is(otherCarpet)) {
            tile.setHeldBlock(otherCarpet.withPropertiesOf(c));
            tile.setChanged();
            return true;
        }
        return false;
    }

    public boolean isDefaultColor(Level level, BlockPos blockPos, BlockState blockState) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof CarpetedBlockTile) {
            CarpetedBlockTile tile = (CarpetedBlockTile)blockEntity;
            BlockState c = tile.getHeldBlock();
            return BlocksColorAPI.isDefaultColor((Block)c.getBlock());
        }
        return false;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return false;
    }
}

