/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.mehvahdjukaar.amendments.common.tile.CarpetedBlockTile;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.block.IRecolorable;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.block.ModStairBlock;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CarpetStairBlock
extends ModStairBlock
implements EntityBlock,
IRecolorable,
IRotatable {
    public static final MapCodec<CarpetStairBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("base_block").forGetter(ModStairBlock::getBaseBlock), (App)CarpetStairBlock.propertiesCodec()).apply((Applicative)i, CarpetStairBlock::new));
    public static final IntegerProperty LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL;
    public static final BooleanProperty SOLID = ModBlockProperties.SOLID;
    protected static final VoxelShape BOTTOM_AABB = Block.box((double)0.0, (double)0.0, (double)-1.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final VoxelShape OCTET_NPN = Block.box((double)0.0, (double)8.0, (double)0.0, (double)9.0, (double)17.0, (double)9.0);
    protected static final VoxelShape OCTET_NPP = Block.box((double)0.0, (double)8.0, (double)7.0, (double)9.0, (double)17.0, (double)16.0);
    protected static final VoxelShape OCTET_PPN = Block.box((double)7.0, (double)8.0, (double)0.0, (double)16.0, (double)17.0, (double)9.0);
    protected static final VoxelShape OCTET_PPP = Block.box((double)7.0, (double)8.0, (double)7.0, (double)16.0, (double)17.0, (double)16.0);
    protected static final VoxelShape[] BOTTOM_SHAPES = CarpetStairBlock.makeShapes();
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    private static VoxelShape[] makeShapes() {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(CarpetStairBlock::makeStairShape).toArray(VoxelShape[]::new);
    }

    private static VoxelShape makeStairShape(int bitfield) {
        Direction dir = switch (bitfield % 4) {
            case 1 -> Direction.EAST;
            case 2 -> Direction.WEST;
            case 3 -> Direction.SOUTH;
            default -> Direction.NORTH;
        };
        VoxelShape voxelShape = MthUtils.rotateVoxelShape((VoxelShape)BOTTOM_AABB, (Direction)dir);
        if ((bitfield & 1) != 0) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)OCTET_NPN);
        }
        if ((bitfield & 2) != 0) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)OCTET_PPN);
        }
        if ((bitfield & 4) != 0) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)OCTET_NPP);
        }
        if ((bitfield & 8) != 0) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)OCTET_PPP);
        }
        return voxelShape;
    }

    public CarpetStairBlock(Block block, BlockBehaviour.Properties properties) {
        super(() -> block, properties.lightLevel(state -> Math.max(0, (Integer)state.getValue((Property)LIGHT_LEVEL))));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)SOLID, (Comparable)Boolean.valueOf(true))).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<? extends CarpetStairBlock> codec() {
        return CODEC;
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && fluidState.getType() == Fluids.WATER) {
            BlockEntity blockEntity;
            if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof CarpetedBlockTile) {
                CarpetedBlockTile te = (CarpetedBlockTile)blockEntity;
                if (level instanceof Level) {
                    Level l = (Level)level;
                    Block.popResource((Level)l, (BlockPos)pos, (ItemStack)te.getCarpet().getBlock().asItem().getDefaultInstance());
                    level.setBlock(pos, (BlockState)te.getHeldBlock().getBlock().withPropertiesOf(state).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                    level.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
                }
            }
            return true;
        }
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue((Property)HALF) == Half.BOTTOM) {
            return BOTTOM_SHAPES[SHAPE_BY_STATE[CarpetStairBlock.getShapeIndex(state)]];
        }
        return super.getShape(state, level, pos, context);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)SOLID) != false ? super.getOcclusionShape(state, level, pos) : Shapes.empty();
    }

    private static int getShapeIndex(BlockState state) {
        return ((StairsShape)state.getValue((Property)SHAPE)).ordinal() * 4 + ((Direction)state.getValue((Property)FACING)).get2DDataValue();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIGHT_LEVEL, SOLID});
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        IBlockHolder tile;
        BlockState mimicState;
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof IBlockHolder && !(mimicState = (tile = (IBlockHolder)blockEntity).getHeldBlock()).isAir() && !(mimicState.getBlock() instanceof CarpetStairBlock)) {
            return mimicState.getDestroyProgress(player, worldIn, pos);
        }
        return super.getDestroyProgress(state, player, worldIn, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        CarpetedBlockTile tile;
        SoundType mixed;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CarpetedBlockTile && (mixed = (tile = (CarpetedBlockTile)blockEntity).getSoundType()) != null) {
            return mixed;
        }
        return super.getSoundType(state);
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        super.destroy(level, pos, state);
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        IBlockHolder tile;
        BlockState mimicState;
        super.spawnDestroyParticles(level, player, pos, state);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IBlockHolder && !(mimicState = (tile = (IBlockHolder)blockEntity).getHeldBlock(1)).isAir()) {
            SoundType sound = mimicState.getSoundType();
            level.playSound(null, pos, sound.getBreakSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, this.soundType.getPitch() * 0.8f);
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof IBlockHolder) {
            IBlockHolder tile = (IBlockHolder)object;
            BlockState heldState = tile.getHeldBlock(0);
            BlockState carpet = tile.getHeldBlock(1);
            Object object2 = builder.getOptionalParameter(LootContextParams.THIS_ENTITY);
            if (object2 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)object2;
                if (ForgeHelper.canHarvestBlock((BlockState)heldState, (ServerLevel)builder.getLevel(), (BlockPos)BlockPos.containing((Position)((Position)builder.getParameter(LootContextParams.ORIGIN))), (ServerPlayer)player)) {
                    drops.addAll(heldState.getDrops(builder));
                }
            }
            drops.addAll(carpet.getDrops(builder));
        }
        return drops;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CarpetedBlockTile) {
            BlockHitResult hs;
            CarpetedBlockTile tile = (CarpetedBlockTile)blockEntity;
            if (target instanceof BlockHitResult && (hs = (BlockHitResult)target).getDirection() == Direction.UP) {
                return tile.getHeldBlock(1).getBlock().getCloneItemStack(level, pos, state);
            }
            BlockState mimic = tile.getHeldBlock();
            return mimic.getBlock().getCloneItemStack(level, pos, state);
        }
        return super.getCloneItemStack(level, pos, state);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CarpetedBlockTile) {
            CarpetedBlockTile tile = (CarpetedBlockTile)blockEntity;
            BlockState mimic = tile.getHeldBlock();
            return mimic.getBlock().getCloneItemStack(level, pos, state);
        }
        return super.getCloneItemStack(level, pos, state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new CarpetedBlockTile(pPos, pState);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        BlockState newState = super.updateShape(state, facing, facingState, world, currentPos, facingPos);
        BlockEntity blockEntity = world.getBlockEntity(currentPos);
        if (blockEntity instanceof CarpetedBlockTile) {
            BlockEntity blockEntity2;
            CarpetedBlockTile tile = (CarpetedBlockTile)blockEntity;
            BlockState oldHeld = tile.getHeldBlock();
            CarpetedBlockTile otherTile = null;
            if (facingState.is(ModRegistry.CARPET_STAIRS.get()) && (blockEntity2 = world.getBlockEntity(facingPos)) instanceof CarpetedBlockTile) {
                CarpetedBlockTile te2;
                otherTile = te2 = (CarpetedBlockTile)blockEntity2;
                facingState = otherTile.getHeldBlock();
            }
            BlockState newHeld = oldHeld.updateShape(facing, facingState, world, currentPos, facingPos);
            BlockState newFacing = facingState.updateShape(facing.getOpposite(), newHeld, world, facingPos, currentPos);
            if (newFacing != facingState) {
                if (otherTile != null) {
                    otherTile.setHeldBlock(newFacing);
                    otherTile.setChanged();
                } else {
                    world.setBlock(facingPos, newFacing, 2);
                }
            }
            if (newHeld != oldHeld) {
                tile.setHeldBlock(newHeld);
            }
        }
        return newState;
    }

    public boolean tryRecolor(Level level, BlockPos blockPos, BlockState blockState, @Nullable DyeColor dyeColor) {
        Block otherCarpet;
        CarpetedBlockTile tile;
        BlockState c;
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof CarpetedBlockTile && !(c = (tile = (CarpetedBlockTile)blockEntity).getHeldBlock()).isAir() && (otherCarpet = BlocksColorAPI.changeColor((Block)c.getBlock(), (DyeColor)dyeColor)) != null && !c.is(otherCarpet)) {
            tile.setHeldBlock(otherCarpet.withPropertiesOf(c));
            tile.setChanged();
            return true;
        }
        return false;
    }

    public boolean isDefaultColor(Level level, BlockPos blockPos, BlockState blockState) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof CarpetedBlockTile) {
            CarpetedBlockTile tile = (CarpetedBlockTile)blockEntity;
            BlockState c = tile.getHeldBlock();
            return BlocksColorAPI.isDefaultColor((Block)c.getBlock());
        }
        return false;
    }

    public Optional<BlockState> getRotatedState(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos, Rotation rotation, Direction direction, @Nullable Vec3 vec3) {
        return direction.getAxis().isVertical() ? Optional.of(this.rotate(blockState, rotation)) : Optional.empty();
    }

    public void onRotated(BlockState newState, BlockState oldState, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CarpetedBlockTile) {
            CarpetedBlockTile tile = (CarpetedBlockTile)blockEntity;
            BlockState held = tile.getHeldBlock();
            BlockState newHeld = held.rotate(rotation);
            tile.setHeldBlock(newHeld);
            tile.setChanged();
        }
    }
}

