/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.item;

import net.mehvahdjukaar.amendments.common.ProjectileStats;
import net.mehvahdjukaar.amendments.common.entity.MediumDragonFireball;
import net.mehvahdjukaar.amendments.common.entity.MediumFireball;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;

public class DragonChargeItem
extends Item
implements ProjectileItem {
    public DragonChargeItem(Item.Properties properties) {
        super(properties);
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        MediumFireball snowball = new MediumFireball(level, pos.x(), pos.y(), pos.z());
        snowball.setItem(stack);
        return snowball;
    }

    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileStats.DISPENSER_CONFIG;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        level.playSound(null, player.getX(), player.getEyeY() - 0.1, player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        player.getCooldowns().addCooldown((Item)this, CommonConfigs.CHARGES_COOLDOWN.get().intValue());
        if (!level.isClientSide) {
            MediumDragonFireball snowball = new MediumDragonFireball(level, (LivingEntity)player);
            snowball.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.1f, 1.0f);
            level.addFreshEntity((Entity)snowball);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    private void playSound(Level level, BlockPos pos) {
        RandomSource randomSource = level.getRandom();
        level.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, (randomSource.nextFloat() - randomSource.nextFloat()) * 0.2f + 1.0f);
    }
}

