/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.events;

import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.InteractEvents;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SoulFiredCompat;
import net.mehvahdjukaar.amendments.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModEvents {
    public static InteractionResult onRightClickBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.isSpectator()) {
            return InteractEvents.onItemUsedOnBlock(player, level, player.getItemInHand(hand), hand, hitResult);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult onRightClickBlockHP(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.isSpectator()) {
            return InteractEvents.onItemUsedOnBlockHP(player, level, player.getItemInHand(hand), hand, hitResult);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResultHolder<ItemStack> onUseItem(Player player, Level level, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isSpectator()) {
            return InteractEvents.onItemUseLP(player, level, hand, stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public static InteractionResult onAttackEntity(Player player, Level level, InteractionHand hand, Entity target, @Nullable EntityHitResult entityHitResult) {
        ItemStack offHand;
        InteractionResult ret;
        ItemStack stack = player.getItemInHand(hand);
        if (CommonConfigs.TORCH_FIRE_OFFHAND.get().booleanValue() && (ret = ModEvents.torchEntity(player, level, target, offHand = hand == InteractionHand.MAIN_HAND ? player.getOffhandItem() : player.getMainHandItem())).consumesAction()) {
            return ret;
        }
        return ModEvents.torchEntity(player, level, target, stack);
    }

    @NotNull
    private static InteractionResult torchEntity(Player player, Level level, Entity target, ItemStack stack) {
        if (stack.is(ModTags.SET_ENTITY_ON_FIRE) && target.isAttackable() && !target.skipAttackInteraction((Entity)player) && target instanceof LivingEntity && !target.isOnFire()) {
            int duration = CommonConfigs.TORCH_FIRE_DURATION.get();
            if (CompatHandler.SOUL_FIRED) {
                SoulFiredCompat.setSecondsOnFire(target, duration, stack);
            } else {
                target.setRemainingFireTicks(duration);
            }
            if (stack.is(ILightable.FLINT_AND_STEELS)) {
                target.playSound(SoundEvents.FLINTANDSTEEL_USE, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            } else {
                target.playSound(SoundEvents.FIRECHARGE_USE, 0.5f, 1.3f + level.getRandom().nextFloat() * 0.2f);
            }
        }
        return InteractionResult.PASS;
    }
}

