/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.events.behaviors;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.amendments.common.block.CommonCauldronCode;
import net.mehvahdjukaar.amendments.common.block.LiquidCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.BlockUse;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.amendments.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CauldronConversion
implements BlockUse {
    @Override
    public boolean isEnabled() {
        return CommonConfigs.LIQUID_CAULDRON.get();
    }

    @Override
    public boolean appliesToBlock(Block block) {
        return Blocks.CAULDRON == block;
    }

    @Override
    public InteractionResult tryPerformingAction(BlockState state, BlockPos pos, Level level, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
        if (player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        return null;
    }

    public static ItemInteractionResult convert(BlockState state, BlockPos pos, Level level, Player player, InteractionHand hand, ItemStack stack, boolean checkCauldronInteractions) {
        BlockEntity blockEntity;
        BlockState newState = CauldronConversion.getNewState(pos, level, stack, checkCauldronInteractions);
        if (newState != null && level.setBlockAndUpdate(pos, newState) && (blockEntity = level.getBlockEntity(pos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            if (te.interactWithPlayerItem(player, hand, stack)) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            level.setBlockAndUpdate(pos, state);
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static BlockState getNewState(BlockPos pos, Level level, ItemStack stack) {
        return CauldronConversion.getNewState(pos, level, stack, true);
    }

    @Nullable
    public static BlockState getNewState(BlockPos pos, Level level, ItemStack fluidBottle, boolean checkCauldronInteractions) {
        Pair fluid = SoftFluidStack.fromItem((ItemStack)fluidBottle);
        if (fluid == null) {
            return null;
        }
        SoftFluidStack first = (SoftFluidStack)fluid.getFirst();
        if (checkCauldronInteractions && ((CauldronBlock)Blocks.CAULDRON).interactions.map().containsKey(fluidBottle.getItem()) && !first.is(MLBuiltinSoftFluids.POTION)) {
            return null;
        }
        if (CompatHandler.RATS && fluidBottle.is(Items.MILK_BUCKET)) {
            return null;
        }
        return CauldronConversion.getNewState(pos, level, first);
    }

    @Nullable
    public static BlockState getNewState(BlockPos pos, Level level, SoftFluidStack fluid) {
        if (fluid.isEmpty()) {
            return Blocks.CAULDRON.defaultBlockState();
        }
        if (fluid.is(MLBuiltinSoftFluids.WATER)) {
            return (BlockState)((BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(Math.min(3, fluid.getCount())))).setValue((Property)LiquidCauldronBlock.BOILING, (Comparable)Boolean.valueOf(CommonCauldronCode.shouldBoil(level.getBlockState(pos.below()), fluid, (LevelAccessor)level, pos.below())));
        }
        if (fluid.is(MLBuiltinSoftFluids.POWDERED_SNOW) && fluid.getCount() == 4) {
            return Blocks.POWDER_SNOW_CAULDRON.defaultBlockState();
        }
        if (fluid.is(MLBuiltinSoftFluids.LAVA) && fluid.getCount() == 4) {
            return Blocks.LAVA_CAULDRON.defaultBlockState();
        }
        if (!fluid.is(ModTags.CAULDRON_BLACKLIST)) {
            BlockState newState = fluid.is(ModRegistry.DYE_SOFT_FLUID) ? ModRegistry.DYE_CAULDRON.get().defaultBlockState() : ModRegistry.LIQUID_CAULDRON.get().defaultBlockState();
            BlockPos belowPos = pos.below();
            return (BlockState)newState.setValue((Property)LiquidCauldronBlock.BOILING, (Comparable)Boolean.valueOf(CommonCauldronCode.shouldBoil(level.getBlockState(belowPos), fluid, (LevelAccessor)level, belowPos)));
        }
        return null;
    }

    public static void setCorrectCauldronStateAndTile(BlockState state, Level level, BlockPos pos, SoftFluidStack resultFluid) {
        BlockState newState = CauldronConversion.getNewState(pos, level, resultFluid);
        if (newState != null) {
            LiquidCauldronBlockTile te;
            BlockEntity blockEntity;
            if (state != newState) {
                level.setBlockAndUpdate(pos, newState);
            }
            if ((blockEntity = level.getBlockEntity(pos)) instanceof LiquidCauldronBlockTile && (blockEntity = (te = (LiquidCauldronBlockTile)blockEntity).getBlockState().getBlock()) instanceof ModCauldronBlock) {
                ModCauldronBlock mc = (ModCauldronBlock)blockEntity;
                te.getSoftFluidTank().setFluid(resultFluid);
                te.setChanged();
            }
        }
    }

    public static class DispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        public DispenserBehavior(Item item) {
            super(item);
        }

        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            ServerLevel level = source.level();
            BlockState originalState = source.state();
            BlockPos pos = source.pos().relative((Direction)originalState.getValue((Property)DispenserBlock.FACING));
            if (!originalState.is(Blocks.CAULDRON)) {
                return InteractionResultHolder.pass((Object)stack);
            }
            BlockState newState = CauldronConversion.getNewState(pos, (Level)level, stack);
            if (newState != null) {
                level.setBlockAndUpdate(pos, newState);
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof LiquidCauldronBlockTile) {
                    LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
                    SoftFluidTank tank = te.getSoftFluidTank();
                    ItemStack returnStack = tank.interactWithItem(stack, (Level)level, pos, false);
                    if (returnStack != null) {
                        level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
                        return InteractionResultHolder.success((Object)returnStack);
                    }
                    level.setBlockAndUpdate(pos, originalState);
                }
            }
            return InteractionResultHolder.pass((Object)stack);
        }
    }
}

