/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.mixins;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.amendments.client.renderers.SignRendererExtension;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SignRenderer.class})
public abstract class SignRendererMixin {
    @Unique
    private static Float amendments$signYaw;
    @Unique
    private static Boolean amendments$front;
    @Unique
    private static final Vec3 OLD_OFFSET;

    @Overwrite
    public static int getDarkColor(SignText signText) {
        int color = signText.getColor().getTextColor();
        if (color == DyeColor.BLACK.getTextColor() && signText.hasGlowingText()) {
            return -988212;
        }
        float scale = 0.4f * ClientConfigs.getSignColorMult();
        if (amendments$front != null && amendments$signYaw != null) {
            Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
            normal.rotateY(amendments$signYaw.floatValue() * ((float)Math.PI / 180) * (float)(amendments$front != false ? 1 : -1));
            amendments$front = null;
            scale *= ColorUtils.getShading((Vector3f)normal);
        }
        return ColorUtils.multiply((int)color, (float)scale);
    }

    @Inject(method={"translateSign(Lcom/mojang/blaze3d/vertex/PoseStack;FLnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="HEAD")})
    private void amendments$captureYaw(PoseStack poseStack, float yaw, BlockState blockState, CallbackInfo ci) {
        amendments$signYaw = Float.valueOf(yaw);
    }

    @Inject(method={"renderSignText(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/SignText;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IIIZ)V"}, at={@At(value="HEAD")})
    private void amendments$captureFace(BlockPos blockPos, SignText signText, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, int k, boolean face, CallbackInfo ci) {
        amendments$front = face;
    }

    @Inject(method={"renderSignWithText(Lnet/minecraft/world/level/block/entity/SignBlockEntity;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/SignBlock;Lnet/minecraft/world/level/block/state/properties/WoodType;Lnet/minecraft/client/model/Model;)V"}, at={@At(value="TAIL")})
    private void amendments$resetYaw(SignBlockEntity signBlockEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, BlockState blockState, SignBlock signBlock, WoodType woodType, Model model, CallbackInfo ci) {
        amendments$signYaw = null;
    }

    @Inject(method={"renderSignModel(Lcom/mojang/blaze3d/vertex/PoseStack;IILnet/minecraft/client/model/Model;Lcom/mojang/blaze3d/vertex/VertexConsumer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void amendments$renderSignModel(PoseStack poseStack, int packedLight, int packedOverlay, Model model, VertexConsumer vertexConsumer, CallbackInfo ci) {
        if (ClientConfigs.PIXEL_CONSISTENT_SIGNS.get().booleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"createSignLayer()Lnet/minecraft/client/model/geom/builders/LayerDefinition;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void amendments$makePixelConsistentModel(CallbackInfoReturnable<LayerDefinition> cir) {
        if (ClientConfigs.PIXEL_CONSISTENT_SIGNS.get().booleanValue()) {
            MeshDefinition meshDefinition = new MeshDefinition();
            PartDefinition partDefinition = meshDefinition.getRoot();
            partDefinition.addOrReplaceChild("sign", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -4.0f, -1.0f, 16.0f, 9.0f, 2.0f), PartPose.ZERO);
            partDefinition.addOrReplaceChild("stick", CubeListBuilder.create().texOffs(0, 14).addBox(-1.0f, 5.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.ZERO);
            cir.setReturnValue((Object)LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32));
        }
    }

    @ModifyReturnValue(method={"getSignModelRenderScale()F"}, at={@At(value="RETURN")})
    private float amendments$signScale(float scale) {
        if (ClientConfigs.PIXEL_CONSISTENT_SIGNS.get().booleanValue() && scale == 0.6666667f) {
            return 1.0f;
        }
        return scale;
    }

    @ModifyReturnValue(method={"getTextOffset()Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")})
    private Vec3 amendments$signTextOffset(Vec3 scale) {
        if (ClientConfigs.PIXEL_CONSISTENT_SIGNS.get().booleanValue() && scale.equals((Object)OLD_OFFSET)) {
            return SignRendererExtension.TEXT_OFFSET;
        }
        return scale;
    }

    @Inject(method={"translateSign(Lcom/mojang/blaze3d/vertex/PoseStack;FLnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="TAIL")})
    private void amendments$signTranslate(PoseStack poseStack, float yRot, BlockState state, CallbackInfo ci) {
        if (ClientConfigs.PIXEL_CONSISTENT_SIGNS.get().booleanValue() && !(state.getBlock() instanceof StandingSignBlock)) {
            SignRendererExtension.translateWall(poseStack);
        }
    }

    static {
        OLD_OFFSET = new Vec3(0.0, 0.3333333432674408, 0.046666666865348816);
    }
}

