/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.options.EntitySelectorOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.playerrevive.PlayerReviveConfig;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.cap.Bleeding;
import team.creative.playerrevive.client.ReviveEventClient;
import team.creative.playerrevive.packet.GiveUpPacket;
import team.creative.playerrevive.packet.HelperPacket;
import team.creative.playerrevive.packet.ReviveUpdatePacket;
import team.creative.playerrevive.server.PlayerReviveServer;
import team.creative.playerrevive.server.ReviveEventServer;

@Mod(value="playerrevive")
public class PlayerRevive {
    public static final Logger LOGGER = LogManager.getLogger((String)"playerrevive");
    public static final String MODID = "playerrevive";
    public static PlayerReviveConfig CONFIG;
    public static final CreativeNetwork NETWORK;
    public static final ResourceLocation BLEEDING_NAME;
    public static final ResourceKey<DamageType> BLED_TO_DEATH;
    public static final SoundEvent DEATH_SOUND;
    public static final SoundEvent REVIVED_SOUND;
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES;
    public static final Supplier<AttachmentType<Bleeding>> BLEEDING;

    public void register(RegisterEvent event) {
        event.register(Registries.SOUND_EVENT, x -> {
            x.register(ResourceLocation.tryBuild((String)MODID, (String)"death"), (Object)DEATH_SOUND);
            x.register(ResourceLocation.tryBuild((String)MODID, (String)"revived"), (Object)REVIVED_SOUND);
        });
    }

    public PlayerRevive(IEventBus bus) {
        if (FMLLoader.getDist() == Dist.CLIENT) {
            bus.addListener(this::client);
        }
        bus.addListener(this::init);
        bus.addListener(this::register);
        NeoForge.EVENT_BUS.addListener(this::serverStarting);
        ATTACHMENT_TYPES.register(bus);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void client(FMLClientSetupEvent event) {
        CreativeCoreClient.registerClientConfig((String)MODID);
        NeoForge.EVENT_BUS.register((Object)new ReviveEventClient());
    }

    private void init(FMLCommonSetupEvent event) {
        NETWORK.registerType(ReviveUpdatePacket.class, ReviveUpdatePacket::new);
        NETWORK.registerType(HelperPacket.class, HelperPacket::new);
        NETWORK.registerType(GiveUpPacket.class, GiveUpPacket::new);
        CONFIG = new PlayerReviveConfig();
        CreativeConfigRegistry.ROOT.registerValue(MODID, (Object)CONFIG);
        NeoForge.EVENT_BUS.register((Object)new ReviveEventServer());
        EntitySelectorOptions.register((String)"bleeding", x -> {
            boolean value = x.getReader().readBoolean();
            x.addPredicate(entity -> {
                boolean entityValue = false;
                if (entity instanceof Player) {
                    Player p = (Player)entity;
                    IBleeding bleeding = PlayerReviveServer.getBleeding(p);
                    entityValue = bleeding.isBleeding();
                }
                return entityValue == value;
            });
        }, x -> true, (Component)Component.translatable((String)"argument.entity.options.bleeding.description"));
    }

    private void serverStarting(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"revive").requires(x -> x.hasPermission(2))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(x -> {
            Collection players = EntityArgument.getPlayers((CommandContext)x, (String)"players");
            for (ServerPlayer player : players) {
                if (!PlayerReviveServer.getBleeding((Player)player).isBleeding()) continue;
                PlayerReviveServer.revive((Player)player);
            }
            return 0;
        })));
    }

    static {
        NETWORK = new CreativeNetwork(1, LOGGER, ResourceLocation.tryBuild((String)MODID, (String)"main"));
        BLEEDING_NAME = ResourceLocation.tryBuild((String)MODID, (String)"bleeding");
        BLED_TO_DEATH = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.tryBuild((String)MODID, (String)"bled_to_death"));
        DEATH_SOUND = SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.tryBuild((String)MODID, (String)"death"));
        REVIVED_SOUND = SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.tryBuild((String)MODID, (String)"revived"));
        ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)MODID);
        BLEEDING = ATTACHMENT_TYPES.register(BLEEDING_NAME.getPath(), () -> AttachmentType.serializable(() -> new Bleeding()).build());
    }
}

