/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.more_bows_and_arrows.mixin;

import common.com.cursee.more_bows_and_arrows.core.registry.ModEnchantments;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BowItem.class})
public class BowItemMixin {
    private ItemStack more_bows_and_arrows$stack;

    @Redirect(method={"releaseUsing"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/BowItem;getPowerForTime(I)F"))
    private float injected(int charge) {
        return BowItemMixin.more_bows_and_arrows$getPowerForTime(this.more_bows_and_arrows$stack, charge);
    }

    @Inject(method={"releaseUsing"}, at={@At(value="HEAD")})
    private void more_bows_and_arrows$releaseUsing$handleDefensiveShot(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft, CallbackInfo ci) {
        this.more_bows_and_arrows$stack = stack;
        if (!(entityLiving instanceof Player)) {
            return;
        }
        Player player = (Player)entityLiving;
        if (player.getProjectile(stack).isEmpty()) {
            return;
        }
        int i = 72000 - timeLeft;
        float f = BowItemMixin.more_bows_and_arrows$getPowerForTime(stack, i);
        if ((double)f < 0.1) {
            return;
        }
        int defenseShotLevel = 0;
        List list = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).entrySet().stream().toList();
        for (Object2IntMap.Entry entry : list) {
            if (!((Holder)entry.getKey()).is(ModEnchantments.DEFENSIVE_SHOT)) continue;
            defenseShotLevel = entry.getIntValue();
            break;
        }
        if (defenseShotLevel > 0) {
            for (int amount = 0; amount < defenseShotLevel; ++amount) {
                List nearby = level.getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, (LivingEntity)player, player.getBoundingBox().inflate(8.0, 0.0, 8.0));
                if (nearby.isEmpty()) {
                    return;
                }
                LivingEntity nearest = (LivingEntity)nearby.get(0);
                BlockPos nearestPos = ((LivingEntity)nearby.get(0)).blockPosition();
                Arrow arrow = new Arrow(level, (LivingEntity)player, new ItemStack((ItemLike)Items.ARROW), stack);
                arrow.pickup = AbstractArrow.Pickup.DISALLOWED;
                double d0 = (double)nearestPos.getX() - arrow.getX();
                double d1 = nearest.getY(0.3333333333333333) - arrow.getY();
                double d2 = (double)nearestPos.getZ() - arrow.getZ();
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                arrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 6.0f);
                player.level().addFreshEntity((Entity)arrow);
            }
        }
    }

    @Inject(method={"releaseUsing"}, at={@At(value="HEAD")})
    private void more_bows_and_arrows$releaseUsing$handleBonusShot(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft, CallbackInfo ci) {
        this.more_bows_and_arrows$stack = stack;
        if (!(entityLiving instanceof Player)) {
            return;
        }
        Player player = (Player)entityLiving;
        if (player.getProjectile(stack).isEmpty()) {
            return;
        }
        int i = 72000 - timeLeft;
        float f = BowItemMixin.more_bows_and_arrows$getPowerForTime(stack, i);
        if ((double)f < 0.1) {
            return;
        }
        int bonusShotLevel = 0;
        List list = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).entrySet().stream().toList();
        for (Object2IntMap.Entry entry : list) {
            if (!((Holder)entry.getKey()).is(ModEnchantments.BONUS_SHOT)) continue;
            bonusShotLevel = entry.getIntValue();
            break;
        }
        if (bonusShotLevel > 0) {
            for (int amount = 0; amount < bonusShotLevel; ++amount) {
                Arrow arrow = new Arrow(level, (LivingEntity)player, new ItemStack((ItemLike)Items.ARROW), stack);
                arrow.pickup = AbstractArrow.Pickup.DISALLOWED;
                arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, f * 3.0f, f * 20.0f);
                player.level().addFreshEntity((Entity)arrow);
            }
        }
    }

    @Unique
    private static float more_bows_and_arrows$getPowerForTime(ItemStack stack, int charge) {
        float amount = 20.0f;
        for (Object2IntMap.Entry entry : EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).entrySet().stream().toList()) {
            if (!((Holder)entry.getKey()).is(ModEnchantments.QUICK_PULL)) continue;
            amount = 10.0f;
            break;
        }
        float f = (float)charge / amount;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }
}

