/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.more_bows_and_arrows.core.registry;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import neoforge.com.cursee.more_bows_and_arrows.Constants;
import neoforge.com.cursee.more_bows_and_arrows.core.ModConfig;
import neoforge.com.cursee.more_bows_and_arrows.core.util.DeferredRegistryObject;
import neoforge.com.cursee.more_bows_and_arrows.core.world.entity.projectile.util.ArrowType;
import neoforge.com.cursee.more_bows_and_arrows.core.world.item.ModArrowItem;
import neoforge.com.cursee.more_bows_and_arrows.core.world.item.ModBowItem;
import neoforge.com.cursee.more_bows_and_arrows.core.world.item.util.BowType;
import neoforge.com.cursee.more_bows_and_arrows.platform.Services;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;

public class ModItems {
    public static final LinkedHashMap<ArrowType, DeferredRegistryObject<Item>> ARROW_ITEM_FROM_TYPE_MAP = new LinkedHashMap();
    public static final LinkedHashMap<BowType, DeferredRegistryObject<Item>> BOW_ITEM_FROM_TYPE_MAP = new LinkedHashMap();
    public static final LinkedList<DeferredRegistryObject<Item>> ITEMS_FOR_TAB = new LinkedList();

    public static void loadClass() {
        ModItems.initializeItems();
    }

    private static void initializeItems() {
        if (!ModConfig.BANNED_BOWS.isEmpty()) {
            Constants.LOG.info("Some bows were banned: ");
            ModConfig.BANNED_BOWS.forEach(System.out::println);
        }
        for (BowType bowType : BowType.values()) {
            DeferredRegistryObject<Item> bow = Services.PLATFORM.register(BuiltInRegistries.ITEM, bowType.name().toLowerCase() + "_bow", () -> new ModBowItem(bowType, new Item.Properties()));
            if (bowType != BowType.NORMAL) {
                ITEMS_FOR_TAB.add(bow);
            }
            BOW_ITEM_FROM_TYPE_MAP.put(bowType, bow);
        }
        if (ModConfig.BANNED_ARROWS != null && !ModConfig.BANNED_ARROWS.isEmpty()) {
            Constants.LOG.info("Some arrows were banned: ");
            ModConfig.BANNED_ARROWS.forEach(System.out::println);
        }
        for (Enum enum_ : ArrowType.values()) {
            DeferredRegistryObject<Item> arrow = Services.PLATFORM.register(BuiltInRegistries.ITEM, enum_.name().toLowerCase() + "_arrow", () -> ModItems.lambda$initializeItems$1((ArrowType)enum_));
            if (enum_ != ArrowType.NORMAL) {
                ITEMS_FOR_TAB.add(arrow);
            }
            ARROW_ITEM_FROM_TYPE_MAP.put((ArrowType)enum_, arrow);
        }
    }

    private static /* synthetic */ Item lambda$initializeItems$1(ArrowType type) {
        return new ModArrowItem(type, new Item.Properties());
    }
}

