/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.more_bows_and_arrows.core.world.item;

import java.util.List;
import neoforge.com.cursee.more_bows_and_arrows.core.ModConfig;
import neoforge.com.cursee.more_bows_and_arrows.core.world.entity.projectile.ModArrow;
import neoforge.com.cursee.more_bows_and_arrows.core.world.entity.projectile.util.ArrowType;
import neoforge.com.cursee.more_bows_and_arrows.core.world.item.util.BowType;
import neoforge.com.cursee.more_bows_and_arrows.core.world.item.util.ModParticleFunctions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ModBowItem
extends BowItem {
    private final BowType type;

    public ModBowItem(BowType type, Item.Properties properties) {
        super(properties.durability(type.getUses()));
        this.type = type;
    }

    public BowType getBowType() {
        return this.type;
    }

    public int getEnchantmentValue() {
        return this.type.getEnchantmentValue();
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return this.type.getRepairIngredient().test(repairCandidate);
    }

    public void hurtLivingEntity(AbstractArrow abstractArrow, LivingEntity owner, LivingEntity hitEntity) {
        if (owner instanceof Player) {
            Player player = (Player)owner;
            hitEntity.invulnerableTime = 0;
            hitEntity.setInvulnerable(false);
            hitEntity.hurtDuration = 0;
            hitEntity.hurtTime = 0;
            hitEntity.hurtMarked = false;
            owner.setLastHurtMob(null);
            hitEntity.setLastHurtByMob(null);
            hitEntity.setLastHurtByPlayer(null);
            hitEntity.hurt(owner.level().damageSources().generic(), this.type.getAttackDamageBonus());
        }
        ModArrow modArrow = abstractArrow instanceof ModArrow ? (ModArrow)abstractArrow : null;
        switch (this.getBowType()) {
            case AMETHYST: {
                break;
            }
            case BLAZE: {
                this.setOnFire(hitEntity);
                break;
            }
            case BONE: {
                break;
            }
            case COAL: {
                if (modArrow == null || modArrow.getArrowType() != ArrowType.FLINT && modArrow.getArrowType() != ArrowType.FLINT_AND_STEEL) break;
                this.setOnFire(hitEntity);
                break;
            }
            case COPPER: {
                break;
            }
            case DIAMOND: {
                break;
            }
            case EMERALD: {
                break;
            }
            case GOLD: {
                break;
            }
            case IRON: {
                if (modArrow == null || modArrow.getArrowType() != ArrowType.FLINT && modArrow.getArrowType() != ArrowType.FLINT_AND_STEEL) break;
                this.setOnFire(hitEntity);
                break;
            }
            case LAPIS: {
                break;
            }
            case MOSS: {
                break;
            }
            case NETHERITE: {
                break;
            }
            case OBSIDIAN: {
                break;
            }
            case PAPER: {
                break;
            }
        }
    }

    private void setOnFire(LivingEntity hitEntity) {
        hitEntity.setRemainingFireTicks(40);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        super.onUseTick(level, entity, stack, remainingUseDuration);
        if (this.type == BowType.NOCTURNAL) {
            ModParticleFunctions.nocturnalBowParticles(level, entity);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        BowType.appendHoverText(this.type, tooltipComponents);
    }

    public boolean isEnabled(FeatureFlagSet enabledFeatures) {
        return !ModConfig.BANNED_BOWS.contains(this.type.name().toLowerCase() + "_bow");
    }
}

